class LowBatLED : Object {
	const string MCE_SERVICE = "com.nokia.mce";
	const string MCE_REQUEST_PATH = "/com/nokia/mce/request";
	const string MCE_REQUEST_IFACE = "com.nokia.mce.request";
	const string BME_SERVICE = "com.nokia.bme";
	const string BME_SIGNAL_PATH = "/com/nokia/bme/signal";
	const string BME_SIGNAL_IFACE = "com.nokia.bme.signal";
	const string BME_REQUEST_PATH = "/com/nokia/bme/request";
	const string BME_REQUEST_IFACE = "com.nokia.bme.request";

	internal string pattern;

	MainLoop loop;
	dynamic DBus.Object bme;
	dynamic DBus.Object mce;

	void on_bme_charger_connected (dynamic DBus.Object bme) {
		print ("charger_connected\n");
		mce.req_led_pattern_deactivate (pattern);
	}

	void on_bme_battery_low (dynamic DBus.Object bme) {
		print ("battery_low\n");
		mce.req_led_pattern_activate (pattern);
	}

	public LowBatLED (DBus.Connection bus) {
		loop = new MainLoop (null);

		bme = bus.get_object (BME_SERVICE, BME_SIGNAL_PATH, BME_SIGNAL_IFACE);
		bme.charger_connected.connect (on_bme_charger_connected);
		bme.battery_low.connect (on_bme_battery_low);

		dynamic DBus.Object bme_req;
		bme_req = bus.get_object (BME_SERVICE, BME_REQUEST_PATH, BME_REQUEST_IFACE);
		bme_req.status_info_req ();

		mce = bus.get_object (MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IFACE);
	}

	public int run () {
		loop.run ();
		return 0;
	}

	static int main (string[] args) {
		try {
			var bus = DBus.Bus.get (DBus.BusType.SYSTEM);
			var app = new LowBatLED (bus);

			string mce_ini;
			if (FileUtils.get_contents ("/etc/mce/mce.ini", out mce_ini) &&
			    mce_ini.contains ("PatternBatteryLow="))
				app.pattern = "PatternBatteryLow";
			else
				app.pattern = "PatternError";

			return app.run ();
		} catch (DBus.Error e) {
			stderr.printf ("Error: %s\n", e.message);
			return 1;
		}
	}
}
