#ifndef VERSION_H
#define VERSION_H

#include <QString>

class VersionClass
{
public:
    VersionClass();

    int GetVersion() const { return m_Version; }
    void SetVersion(int value) { m_Version = value; }

    int GetModify() const { return m_Modify; }
    void SetModify(int value) { m_Modify = value; }

    int GetRevision() const { return m_Revision; }
    void SetRevision(int value) { m_Revision = value; }

    QString ToString();
    void FromString(QString value);

    bool operator>(const VersionClass &versionClass);
    bool operator<(const VersionClass &versionClass);
    bool operator=(const VersionClass &versionClass);
    bool operator!=(const VersionClass &versionClass);

protected:
    QString ToComparableString() const;

private:
    int m_Version;
    int m_Modify;
    int m_Revision;
};

#endif // VERSION_H
