#include "kaidiscipline.h"
#include <QStringList>
#include "book.h"
#include "player.h"

LoreCircle::LoreCircle(QObject *parent, Circles Circle) :
    QObject(parent)
{
    m_Circle = Circle;
}

QString LoreCircle::Name()
{
    switch (m_Circle){
    case CircleOfFire:
        return "Fire";
        break;
    case CircleOfLight:
        return "Light";
        break;
    case CircleOfSolaris:
        return "Solaris";
        break;
    case CircleOfSpirit:
        return "Spirit";
        break;
    default:
        return "";
        break;
    }
}

bool LoreCircle::Check(Player* player)
{
    foreach (QString d, Disciplines){
        if (!player->HasDiscipline(d))
            return false;
    }
    return true;
}

QList<LoreCircle*> LoreCircles::Circles;
LoreCircles::LoreCircles(QObject *parent) :
    QObject(parent)
{

}

void LoreCircles::InitCircles()
{
    ClearCircles();

    LoreCircle* lc = new LoreCircle(NULL, LoreCircle::CircleOfFire);
    lc->CombatSkillBonus = 1;
    lc->EnduranceBonus = 2;
    lc->Disciplines << "Weaponmastery" << "Huntmastery";
    Circles.append(lc);

    lc = new LoreCircle(NULL, LoreCircle::CircleOfLight);
    lc->CombatSkillBonus = 0;
    lc->EnduranceBonus = 3;
    lc->Disciplines << "Animal Control" << "Curing";
    Circles.append(lc);

    lc = new LoreCircle(NULL, LoreCircle::CircleOfSolaris);
    lc->CombatSkillBonus = 1;
    lc->EnduranceBonus = 3;
    lc->Disciplines << "Invisibility" << "Huntmastery" << "Pathsmanship";
    Circles.append(lc);

    lc = new LoreCircle(NULL, LoreCircle::CircleOfSpirit);
    lc->CombatSkillBonus = 3;
    lc->EnduranceBonus = 3;
    lc->Disciplines << "Psi-surge" << "Psi-screen" << "Nexus" << "Divination";
    Circles.append(lc);
}

void LoreCircles::ClearCircles()
{
    foreach (LoreCircle* c, Circles)
        delete c;
    Circles.clear();
}

KaiDiscipline::KaiDiscipline(QObject *parent) :
    QObject(parent)
{
    m_Active = true;
    Name = "";
    HelpText = "";
    CombatSkillDelta = 0;
    Serie = Book::Kai;
}

KaiDiscipline::KaiDiscipline(const KaiDiscipline& discipline) :
    QObject(discipline.parent())
{
    m_Active = discipline.m_Active;
    Name = discipline.Name;
	Serie = discipline.Serie;
    HelpText = discipline.HelpText;
    CombatSkillDelta = discipline.CombatSkillDelta;
}

QString KaiDiscipline::Description()
{
    return Name;
}

QString KaiDiscipline::ToString()
{
    return QString("%1|%2").arg(Name).arg(CombatSkillDelta);
}

void KaiDiscipline::FromString(QString string)
{
    QStringList e = string.split("|");
    if (e.count() >= 2){
        Name = e.at(0);
        CombatSkillDelta = e.at(1).toInt();
    }
}


// Kai:
Camouflage::Camouflage(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Camouflage";
    CombatSkillDelta = 0;
}

Hunting::Hunting(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Hunting";
    HelpText = "no need for a Meal when instructed to eat";
    CombatSkillDelta = 0;
}

SixthSense::SixthSense(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Sixth Sense";
    CombatSkillDelta = 0;
}

Tracking::Tracking(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Tracking";
    CombatSkillDelta = 0;
}

Healing::Healing(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Healing";
    HelpText = "no need for a Meal when instructed to eat";
    CombatSkillDelta = 0;
}

Weaponskill::Weaponskill(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Weaponskill";
    HelpText = "+2 COMBAT SKILL points if this weapon carried";
    CombatSkillDelta = 0;
    Weapon = Weapon::None;
}

Weaponskill::Weaponskill(const Weaponskill& discipline)
    : KaiDiscipline(discipline)
{
    Weapon = discipline.Weapon;
}

QString Weaponskill::Description()
{
    return QString("%1 in %2").arg(Name).arg(Weapon::ClassDescription(Weapon));
}

QString Weaponskill::ToString()
{
    return QString("%1|%2|%3").arg(Name).arg(CombatSkillDelta).arg(Weapon);
}

void Weaponskill::FromString(QString string)
{
    QStringList e = string.split("|");
    if (e.count() >= 3){
        Name = e.at(0);
        CombatSkillDelta = e.at(1).toInt();
        Weapon = e.at(2).toInt();
    }
}

Mindshield::Mindshield(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Mindshield";
    CombatSkillDelta = 0;
}

Mindblast::Mindblast(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Mindblast";
    CombatSkillDelta = 2;
}

AnimalKinship::AnimalKinship(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Animal Kinship";
    CombatSkillDelta = 0;
}

MindOverMatter::MindOverMatter(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Mind Over Matter";
    CombatSkillDelta = 0;
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Magnakai:
Weaponmastery::Weaponmastery(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Weaponmastery";
    HelpText = "+3 COMBAT SKILL points";
    CombatSkillDelta = 0;
    Serie = Book::Magnakai;
}

QString Weaponmastery::ToString()
{
    QString res = QString("%1|%2").arg(Name).arg(CombatSkillDelta);
    foreach (int weapon, Weapons)
        res.append(QString("|%1").arg(weapon));
    return res;
}

void Weaponmastery::FromString(QString string)
{
    Weapons.clear();
    QStringList e = string.split("|");
    if (e.count() >= 2){
        Name = e.at(0);
        CombatSkillDelta = e.at(1).toInt();
        for (int i=2; i<e.count(); i++)
            Weapons.append(e.at(i).toInt());
    }
}

AnimalControl::AnimalControl(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Animal Control";    
    CombatSkillDelta = 0;
    Serie = Book::Magnakai;
}

Curing::Curing(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Curing";
    HelpText = "+1 ENDURANCE point for each section without combat";
    CombatSkillDelta = 0;
    Serie = Book::Magnakai;
}

Invisibility::Invisibility(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Invisibility";    
    CombatSkillDelta = 0;
    Serie = Book::Magnakai;
}

Huntmastery::Huntmastery(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Huntmastery";    
    CombatSkillDelta = 0;
    Serie = Book::Magnakai;
}

Pathsmanship::Pathsmanship(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Pathsmanship";    
    CombatSkillDelta = 0;
    Serie = Book::Magnakai;
}

PsiSurge::PsiSurge(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Psi-surge";
    HelpText = "+4 COMBAT SKILL points but -2 ENDURANCE points per round";
    CombatSkillDelta = 4;
    Serie = Book::Magnakai;
}

PsiScreen::PsiScreen(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Psi-screen";
    HelpText = "no points lost when attacked by Mindforce";
    CombatSkillDelta = 0;
    Serie = Book::Magnakai;
}

Nexus::Nexus(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Nexus";    
    CombatSkillDelta = 0;
    Serie = Book::Magnakai;
}

Divination::Divination(QObject *parent) :
    KaiDiscipline(parent)
{
    Name = "Divination";    
    CombatSkillDelta = 0;
    Serie = Book::Magnakai;
}
