#include "commonstatic.h"
#include <QLayoutItem>
#include <QLabel>
#include <QPushButton>
#ifdef Q_WS_MAEMO_5
#include <QMaemo5Style>
#endif
#include "core/player.h"

CommonStatic::CommonStatic()
{
}

void CommonStatic::Message(QWidget* parent, QString title, QString message)
{
    QMessageBox msgBox(parent);
    msgBox.setWindowTitle(title);
    msgBox.setText(message);
    msgBox.exec();
}

QMessageBox::StandardButton CommonStatic::ConfirmMessage(QWidget* parent, QString title, QString message)
{
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Question);
    if (title.isEmpty())
        title = QObject::tr("Confirm");
    msgBox.setWindowTitle(title);
    msgBox.setText(message);
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    return (QMessageBox::StandardButton)msgBox.exec();
}

QSettings* CommonStatic::GeneralSettings(QObject * parent)
{
    QString filename = QSettings().fileName();
    filename = filename.replace(".ini", QString("_general.ini"), Qt::CaseInsensitive);
    return new QSettings(filename, QSettings::IniFormat, parent);
}

void CommonStatic::CenterWindow(QWidget* w){
    if (w->parent() != NULL){
        QWidget* p = qobject_cast<QWidget*>(w->parent());
        if (p != NULL){
            int newX = p->pos().x() + p->width() - w->width();
            int newY = p->pos().y() + p->height() - w->height();
            if (newX < 0)
                newX = 0;
            if (newY < 0)
                newY = 0;
            w->move(newX, newY);
        }
    }
}

void CommonStatic::ClearLayout(QLayout* layout)
{
    QLayoutItem* child;
    while ((child = layout->takeAt(0)) != 0) {
        delete child->widget();
        delete child;
    }
}

#ifdef Q_WS_MAEMO_5
QPalette CommonStatic::GetSecondaryPalette()
{
    QColor secondaryColor = QMaemo5Style::standardColor("SecondaryTextColor");
    QPalette secondaryPalette(QColor(255,255,255, 0));
    secondaryPalette.setColor(QPalette::Foreground, secondaryColor);
    return secondaryPalette;
}
#endif

void CommonStatic::PopulateSpecialItemsLayout(QWidget* parent, Player* player, QGridLayout* layout,
                                              const char* dropSlot, QString dropLabel,
                                              const char* equipSlot)
{
    ClearLayout(layout);

    int row = 0;
    int index = 0;
    QList<Item*>::const_iterator it;
    for (it = player->Items.constBegin(); it != player->Items.constEnd(); ++it){
        Item* i = *it;
        if (i->GetIsSpecial()){
            int col = 0;

            QLabel* lbl = new QLabel(parent);
            lbl->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);
            lbl->setText(QString("<b>%1:</b>").arg(row + 1));
            layout->addWidget(lbl, row, col++);

            lbl = new QLabel(parent);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            layout->addWidget(lbl, row, col++);

            if(strlen(equipSlot)){
                if (i->GetIsWeapon() || i->GetIsArmor()){
                    QPushButton* pbn = new QPushButton(parent);
                    pbn->setEnabled(i->GetCanBeEquipped());
                    pbn->setObjectName(QString::number(index));
                    if (i->GetIsEquipped()){
                        pbn->setText("Unequip");
#ifdef Q_WS_MAEMO_5
                        pbn->setMaximumSize(120, 50);
#endif
                    }else{
                        pbn->setText("Equip");
#ifdef Q_WS_MAEMO_5
                        pbn->setMaximumSize(75, 50);
#endif
                    }
#ifndef Q_WS_MAEMO_5
                    pbn->setMaximumSize(75, 50);
#endif
                    QObject::connect(pbn, SIGNAL(clicked()), parent, equipSlot);
                    layout->addWidget(pbn, row, col++);
                }else
                    col++;
            }

            QPushButton* pbn = new QPushButton(parent);
            pbn->setObjectName(QString::number(index));
            pbn->setText(dropLabel);
#ifdef Q_WS_MAEMO_5
                pbn->setMaximumSize(120, 50);
#else
                pbn->setMaximumSize(75, 50);
#endif
            QObject::connect(pbn, SIGNAL(clicked()), parent, dropSlot);
            pbn->setEnabled(i->GetCanBeDropped());
            layout->addWidget(pbn, row, col++);

            QString desc = i->GetDescription();
            if (!desc.isEmpty()){
                row++;
                col = 1;
                lbl = new QLabel(parent);
                lbl->setText(i->GetDescription());
                lbl->setWordWrap(true);
                layout->addWidget(lbl, row, col++, 1, 3);
            }
            row++;
        }
        index++;
    }
}

void CommonStatic::PopulateBackpackItemsLayout(QWidget* parent, Player* player, QGridLayout* layout,
                                               const char* dropSlot, QString dropLabel,
                                               const char* useSlot, const char* sellSlot)
{
    ClearLayout(layout);
    int row = 0;
    int index = 0;

    if (strlen(dropSlot) && dropLabel.isEmpty())
        dropLabel = "Drop";

    if (!player->HasBackpack()){
        QLabel* lbl = new QLabel(parent);
        lbl->setText("You don't have the backpack!");
        layout->addWidget(lbl, 0, 0);
    }else{
        QList<Item*>::const_iterator it;
        for (it = player->Items.constBegin(); it != player->Items.constEnd(); ++it){
            Item* i = *it;
            if (i->GetIsBackpackItem()){
                int col = 0;
                QLabel* lbl = new QLabel(parent);
                lbl->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);
                lbl->setText(QString("<b>%1:</b>").arg(row + 1));
                layout->addWidget(lbl, row, col++);

                lbl = new QLabel(parent);
                if (i->IsUsable() && i->GetUsability() > 1)
                    lbl->setText(QString("%1 (%2)")
                                 .arg(i->Name)
                                 .arg(i->GetUsability()));
                else
                    lbl->setText(i->Name);                
                lbl->setWordWrap(true);
                layout->addWidget(lbl, row, col++);

                QPushButton* pbn = NULL;
                if (strlen(useSlot) > 0){
                    pbn = new QPushButton(parent);
                    pbn->setObjectName(QString::number(index));
                    if (i->GetIsMeal())
                        pbn->setText("Eat");
                    else
                        pbn->setText("Use");
                    pbn->setEnabled(i->IsUsable());
                    pbn->setMaximumSize(75, 50);
                    QObject::connect(pbn, SIGNAL(clicked()), parent, useSlot);
                    layout->addWidget(pbn, row, col++);
                }
                pbn = new QPushButton(parent);
                pbn->setObjectName(QString::number(index));                
#ifdef Q_WS_MAEMO_5
                pbn->setMaximumSize(120, 50);
#else
                pbn->setMaximumSize(75, 50);
#endif
                if (strlen(sellSlot) && i->GetSellPrice()){
                    pbn->setText("Sell");
                    QObject::connect(pbn, SIGNAL(clicked()), parent, sellSlot);
                }else{
                    pbn->setText(dropLabel);
                    QObject::connect(pbn, SIGNAL(clicked()), parent, dropSlot);
                    pbn->setEnabled(i->GetCanBeDropped());
                }
                layout->addWidget(pbn, row, col++);

                QString desc = i->GetDescription();
                if (!desc.isEmpty()){
                    row++;
                    col = 1;
                    lbl = new QLabel(parent);
                    lbl->setText(i->GetDescription());
                    lbl->setWordWrap(true);
                    layout->addWidget(lbl, row, col++, 1, 3);
                }

                row++;
                for (int j=1; j<i->GetSize(); j++){
                    QLabel* lbl = new QLabel(parent);
                    lbl->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);
                    lbl->setText(QString("<b>%1:</b>").arg(row + 1));
                    layout->addWidget(lbl, row, 0);

                    lbl = new QLabel(parent);
                    lbl->setText("-");
                    lbl->setWordWrap(true);
                    layout->addWidget(lbl, row, 1);

                    row++;
                }
            }
            index++;
        }

        for (int i=row; i<8; i++){
            int col = 0;
            QLabel* lbl = new QLabel(parent);
            lbl->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);
            lbl->setText(QString("<b>%1:</b>").arg(i + 1));
            layout->addWidget(lbl, i, col++);

            lbl = new QLabel(parent);
            lbl->setText("");
            lbl->setWordWrap(true);
            layout->addWidget(lbl, row, col++);

            QPushButton* pbn = NULL;
            if (strlen(useSlot) > 0){
                pbn = new QPushButton(parent);
                pbn->setText("Use");
                pbn->setEnabled(false);
                pbn->setMaximumSize(75, 50);
                layout->addWidget(pbn, i, col++);
            }
            pbn = new QPushButton(parent);
            pbn->setText(dropLabel);
            pbn->setEnabled(false);
            pbn->setMaximumSize(75, 50);
            layout->addWidget(pbn, i, col++);
        }
    }
}
