#include <QtGui>
#include <QApplication>
#include <iostream>
#include <QCheckBox>
#include <QString>
#include <QLabel>
#include <QPushButton>
#include <QObject>
#include <fstream>
#include <QMaemo5InformationBox>

#include <sys/types.h>
#include <sys/stat.h>


class Handler: public QObject
{
	Q_OBJECT
	
	public:
		Handler(QWidget* window_,QApplication* app_);
		QWidget window;

		QApplication* app;
		QGridLayout* layout;

		QCheckBox *keyboardSound;
		QCheckBox *lockSound;
		QCheckBox *keyboardVibration;
		QCheckBox *lockVibration;
		QLabel* kso;
		QLabel* ksc;
		QPushButton* ksob;
		QPushButton* kscb;
		QLabel* lso;
		QLabel* lsc;
		QPushButton* lsob;
		QPushButton* lscb;

		QPushButton* done;
		
		
		std::string ksos;
		std::string kscs;
		std::string lsos;
		std::string lscs;

		int ks;
		int kv;
		int ls;
		int lv;
		

		void readConfig();
		void writeConfig();
		
	public slots:
		void keyboardSoundChanged(int state);
		void lockSoundChanged(int state);
		
		void keyboardOpenClicked();
		void keyboardClosedClicked();
		void lockOpenClicked();
		void lockClosedClicked();
			
		void keyboardVibChanged(int state);
		void lockVibChanged(int state);

		void doneSlot();

};
