#include <QApplication>
#include "mainwindow.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QCoreApplication::setApplicationVersion("0.6.4");
    QCoreApplication::setApplicationName("Liquid");

    QString locale = QLocale::system().name();
    QTranslator myTranslator;
    myTranslator.load(QString(APP_NAME) + "_" + locale,
                      DATADIR"/translations/");
    app.installTranslator(&myTranslator);

    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name(),
                      QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qtTranslator);

    MainWindow w;
    w.show();
    return app.exec();
}
