/*
 * This file is part of the Liquid project.
 * This class provides Help in application.
 *
 * Copyright (C) 2009 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2009 Volkov A.A. <volkov@cs.karelia.ru>
 * Copyright (C) 2009 Dmitriev V.V. <vdmitrie@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "help.h"

#define AMOUNT 4

Help::Help(QWidget *parent) :
    QDialog(parent)
{
    layout = new QGridLayout;
    layout->geometry().setHeight(400);

    numPages = AMOUNT;
    page = 0;

    prevBtn = new QPushButton(tr("Previous"));
    prevBtn->setVisible(false);

    nextBtn = new QPushButton(tr("Next"));

    imageLabel = new QLabel();
    imageLabel->setBackgroundRole(QPalette::Base);
    imageLabel->setSizePolicy(QSizePolicy::Ignored, QSizePolicy::Ignored);
    imageLabel->setScaledContents(true);

    loadImage(":/help/0.png");

    layout->addWidget(imageLabel, 0, 0, 3, 2);
    layout->addWidget(prevBtn, 4, 0);
    layout->addWidget(nextBtn, 4, 1);

    setLayout(layout);

    connect(prevBtn, SIGNAL(clicked()), SLOT(previous()));
    connect(nextBtn, SIGNAL(clicked()), SLOT(next()));

    setWindowTitle("Help");
    resize(800, 480);
}

// Load previous page
void Help::previous() {
    page--;

    loadImage(QString("%1%2%3").arg(":/help/").arg(page).arg(".png"));

    if (!nextBtn->isVisible())
        nextBtn->setVisible(true);

    if (page == 0) {
        if (prevBtn->isVisible()) {
            prevBtn->setVisible(false);
        }
    }
}

// Load next page
void Help::next() {
    page++;

    loadImage(QString("%1%2%3").arg(":/help/").arg(page).arg(".png"));

    if (!prevBtn->isVisible())
        prevBtn->setVisible(true);

    if (page == AMOUNT) {
        if (nextBtn->isVisible()) {
            nextBtn->setVisible(false);
        }
    }

}

// Loads image
void Help::loadImage(const QString &fileName) {
    QImage image(fileName);
    if (image.isNull()) {
        QMessageBox::information(this,
                                 tr("Help"),
                                 tr("Cannot load %1.").arg(fileName));
        return;
    }
    imageLabel->setPixmap(QPixmap::fromImage(image));
}

