/*
 * This file is part of the Liquid project.
 * It is header file of class ErrorHandler, which realizes error handling for
 * application.
 *
 * Copyright (C) 2009 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2009 Volkov A.A. <volkov@cs.karelia.ru>
 * Copyright (C) 2009 Dmitriev V.V. <vdmitrie@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

//! Error Handler Module.
/*!
  This module handles errors from other modules.
  Error codes are stored in errors.h
*/

#ifndef ERRORHANDLER_H
#define ERRORHANDLER_H

#include <QString>
#include <QDialog>
#include <QMessageBox>
#include <QObject>

class ErrorHandler : public QWidget
{
    Q_OBJECT;

public:

    ErrorHandler(QWidget *parent = 0);
    void returnError(int code);

private:
    //! Shows error message.
    /*!
      \param error - error's message.
      \param info - additional information about error.
    */
    void showError(const QString error, const QString info);

signals:
    //! Signal
    /*!
      Genereates if fatal error in accelerometer module occured.
    */
    void accFatalError();
};

#endif // ERRORHANDLER_H
