#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <math.h>
#include <QColor>
#include <QColorDialog>
#include <QFileDialog>
#include <QDialog>
#include <QMessageBox>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    velocityX = 0;
    velocityY = 0;
    m_pos = QPointF(50,50);
    posXPrev = 200;
    posYPrev = 200;

    ui->setupUi(this);
    isPainting = false;
    painter = new Painter(this);
    acc = new Accelerometer(this);
    ui->horizontalLayout->addWidget(painter);

    ui->horizontalLayout->addWidget(painter);

    /*
    ui->toolButton->setIcon(QIcon(":/color_line.png"));
    ui->toolButton->setIconSize(QSize(64, 64));

    ui->toolButton_2->setIcon(QIcon(":/drop.png"));
    ui->toolButton_2->setIconSize(QSize(64, 64));

    ui->toolButton_3->setIcon(QIcon(":/zoom.png"));
    ui->toolButton_3->setIconSize(QSize(64, 64));

    ui->horizontalSlider->setSliderPosition(painter->m_size);
    ui->spinBox->setValue(painter->m_size);

    connect(ui->spinBox, SIGNAL(valueChanged(int)), SLOT(setBrushThickness(int)));
    connect(ui->toolButton_2, SIGNAL(clicked()), SLOT(setEraser()));
    connect(ui->toolButton, SIGNAL(clicked()), SLOT(showColorDialog()));
    connect(ui->horizontalSlider, SIGNAL(valueChanged(int)), SLOT(setBrushThickness(int)));
    connect(acc, SIGNAL(deviceOrientationChanged(QVector3D)), SLOT(setBrushPosition(QVector3D)));
    connect(ui->pushButton, SIGNAL(pressed()), SLOT(setPaintingActive()));
    connect(ui->pushButton, SIGNAL(released()), SLOT(disablePainting()));

    createActions();
    createMenus();
    */
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::open()
{
    const QString fileName = QFileDialog::getOpenFileName(this,
                                                          tr("Open File"),
                                                          QDir::currentPath());
    if (!fileName.isEmpty()) {
        if (!painter->openImage(fileName)) {
            QMessageBox::information(this, tr("Pearl"),
                                     tr("Cannot load %1.").arg(fileName));
            return;
        }
        painter->adjustSize();
    }
}

bool MainWindow::saveAs()
{
    const QString initialPath = QDir::currentPath() + "/untitled.png";

    const QString fileName = QFileDialog::getSaveFileName(this, tr("Save As"),
                                                          initialPath);
    if (fileName.isEmpty()) {
        return false;
    } else {
        return painter->saveImage(fileName, "png");
    }
}

void MainWindow::createActions() {
    openAct = new QAction(tr("&Open..."), this);
    openAct->setShortcuts(QKeySequence::Open);
    connect(openAct, SIGNAL(triggered()), this, SLOT(open()));

    saveAsAct = new QAction(tr("&Save As..."), this);
    saveAsAct->setShortcuts(QKeySequence::SaveAs);
    connect(saveAsAct, SIGNAL(triggered()), this, SLOT(saveAs()));

    exitAct = new QAction(tr("E&xit"), this);
    exitAct->setShortcuts(QKeySequence::Close);
    connect(exitAct, SIGNAL(triggered()), this, SLOT(close()));
}

void MainWindow::createMenus() {
    fileMenu = menuBar()->addMenu(tr("&File"));
    fileMenu->addAction(openAct);
    fileMenu->addAction(saveAsAct);
    fileMenu->addSeparator();
    fileMenu->addAction(exitAct);

    ui->menuBar->addMenu(fileMenu);
}

void MainWindow::setEraser() {
    painter->setTool("eraser");
}

void MainWindow::showColorDialog() {
    QColor color = QColorDialog::getColor(Qt::green, this);
         if (color.isValid()) {
             painter->setColor(color);
         }
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::setBrushThickness(int size) {
    painter->setThickness(size);
    //ui->horizontalSlider->setSliderPosition(size);
    //ui->spinBox->setValue(size);
}

void MainWindow::setPaintingActive() {
    isPainting = true;
}

void MainWindow::disablePainting() {
    isPainting = false;
}

void MainWindow::setBrushPosition(QVector3D accVector3) {
    int directionX = 1;
    int directionY = 1;    
    
    if(accVector3.x() < 0)
        directionX = -1;

    if(accVector3.y() < 0)
        directionY = -1;

    painter->setPosition(accVector3, isPainting);
}

