// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>


#define ABS(a) ( (a)<0 ? -(a) : (a) )
		
//#####################################################################
//#####################################################################
//##################################################################### liqmandel_run :: by gary birkett
//#####################################################################
//#####################################################################



int maxiter=256;

float cx=0;
float cy=0;
float magx=4;
float magy=4;
float pixstepx=0;
float pixstepy=0;

int viewmaxx=0;
int viewmaxy=0;

int viewuptox=0;
int viewuptoy=0;
int viewstepx=0;
int viewstepy=0;
int viewinprogress=0;




void calcstrip(liqcliprect *icr,int pixelsize,  int psx,int psy,       float startr,float starti,        float mandw,float mandh)
{
// now i have v0.0.1 lets optimize it :)
//	liqcliprect icr;
//	liqcliprect_initfromimage(&icr,image);
liqimage *image = icr->surface;
int px=psx;
int py=psy;
float zr=0;
float zi=0;
float zr1=0;
float zi1=0;
float r;
int iter=0;
float crstep = mandw / (float)image->width * (float)pixelsize;
float cistep = mandh / (float)image->height* (float)pixelsize;
float cr=startr;
float ci=starti;
	
	//for(py=psy;py<image->height;py+=pixelsize)
	//{
	//	cr=startr;
		for(px=psx;px<image->width;px+=pixelsize)
		{
			zr=cr;
			zi=ci;
			for(iter=0;iter<maxiter;iter++)
			{
				zr1 = (zr*zr) - (zi*zi) + cr;
				zi1 = 2 * (zr*zi) + ci;
				r = (zr1*zr1 + zi1*zi1);
				if(r>4)
					break;
				zr=zr1;
				zi=zi1;
			}
			if(iter==maxiter)iter=255;
			liqcliprect_drawboxfillcolor(icr,px,py,pixelsize,pixelsize,(char)iter,(char)zr1*64,(char)zi1*64);
			cr+=crstep;
		}
	//	ci+=cistep;
	//}
}






void mand_prep(liqcliprect *icr)
{
liqimage *image = icr->surface;
	viewmaxx=image->width;
	viewmaxy=image->height;
	viewuptox=0;
	viewuptoy=0;
	viewstepx=16;
	viewstepy=16;
	viewinprogress=1;
	pixstepx = magx / (float)viewmaxx ;//* (float)pixelsize;
	pixstepy = magy / (float)viewmaxy ;//* (float)pixelsize;
}

void mand_calcstrip_int(liqcliprect *icr)
{
liqimage *image = icr->surface;
	if(viewuptoy>=viewmaxy) return;
	// generate a strip of mandel data here..
	
	// greyscale
	//cliprect icr;
	//cliprect_initfromimage(&icr,image);	
	//cliprect_drawboxfillcolor(&icr,0,viewuptoy,viewmaxx,viewstepy,viewuptoy,128,128);
	
	calcstrip(icr,viewstepy,     0,viewuptoy,        cx-(magx/2), cy-(magy/2)+pixstepy*((float)viewuptoy)    , magx,magy );
	
	
	
	viewuptoy+=viewstepy;
	if(viewuptoy>=viewmaxy)
	{
		if(viewstepy==1)
		{
			// finished!
			viewinprogress=0;
			return;
		}
		// half step and run again
		viewstepy/=2;
		viewuptoy=0;
	}
}
void mand_calcstrip(liqcliprect *icr)
{
liqimage *image = icr->surface;
	if(viewuptoy>=viewmaxy) return;
	int a;
	if(viewstepy==16)
	{
		// whole frame
		for(a=0;a<64;a++)
		{
			mand_calcstrip_int(icr);
			if(viewstepy!=16)break;
		}
	}
	else
	{
		for(a=0;a<8;a++)
		{
			mand_calcstrip_int(icr);
		}
	}
}























	
		
/**	
 * liqmandel_run widget filter, the system is asking you to filter to the specified .
 */	
static int liqmandel_run_filter(liqcell *self,liqcellfiltereventargs *args, liqcell *context)
{
	// system is indicating the user has typed into the search box
	// you are expected to filter your content based upon this searchterm.
	// show or hide details and rearrange contents to apply this filter.
	char *searchterm = NULL;
	args->resultoutof=0;  // total number of searchable contents
	args->resultshown=0;  // count of options remaining after filtering.
	searchterm = args->searchterm;
	if(searchterm && *searchterm)
	{
		 // check the name property
		 args->resultoutof++;
		 if( stristr(self->name,searchterm) != NULL )
		 {
			  args->resultshown++;
		 }
		 // check the classname property
		 args->resultoutof++;
		 if( stristr(self->classname,searchterm) != NULL )
		 {
			  args->resultshown++;
		 }
		 // check any other properties or children and increment counters
		 // filter out list items recursively
	}
	return 0;
}
/**	
 * liqmandel_run widget refresh, all params set, present yourself to the user.
 */	
static int liqmandel_run_refresh(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_run dialog_open - the user zoomed into the dialog
 */	
static int liqmandel_run_dialog_open(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	 return 0;
}
/**	
 * liqmandel_run dialog_close - the dialog was closed
 */	
static int liqmandel_run_dialog_close(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	 return 0;
}
/**	
 * liqmandel_run widget shown - occurs once per lifetime
 */	
static int liqmandel_run_shown(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_run mouse - occurs all the time as you stroke the screen
 */	
static int liqmandel_run_mouse(liqcell *self, liqcellmouseeventargs *args,liqcell *context)
{
	if(args->mez>0)
	{
		// stroke in progress
		//
		if(args->mdx || args->mdy)
		{
			cx -= (float)args->mdx * pixstepx;
			cy -= (float)args->mdy * pixstepy;
			mand_prep(canvas.cr);
			//mand_calcstrip(canvas.surface);
		}
	}
	else
	{
		if( ABS(args->msx-args->mex) < 8 && ABS(args->mey-args->mey) < 8 )
		{

				magx*=0.75;
				magy*=0.75;
				mand_prep(canvas.cr);
				liqcell_setdirty(self,1);
		}
	}
	return 0;
}
/**	
 * liqmandel_run click - occurs when a short mouse stroke occured
 */	
static int liqmandel_run_click(liqcell *self, liqcellclickeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_run keypress - the user pressed a key
 */	
static int liqmandel_run_keypress(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_run keyrelease - the user released a key
 */	
static int liqmandel_run_keyrelease(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_run paint - being rendered.  use the vgraph held in args to do custom drawing at scale
 */	
static int liqmandel_run_paint(liqcell *self, liqcellpainteventargs *args,liqcell *context)
{
	if(viewinprogress==0) return 0;
	// big heavy event, use sparingly

	int sw=((int)self->w);
	int sh=((int)self->h);

	liqimage *img = liqcell_getimage(self);
	int iw=0;
	int ih=0;
	if(img)
	{
		iw = img->width;
		ih = img->height;
	}
	if(sw!=iw || sh!=ih)
	{
		liqcell_setimage(self, img = liqimage_newatsize( sw,sh,0) );
	}
	liqcliprect *icr = liqcliprect_newfromimage(img);
	mand_calcstrip(icr);
	liqcliprect_release(icr);
	
	

	//mand_calcstrip(args->graph->cliprect);
	liqcell_setdirty(self,1);
	return 0;
}
/**	
 * liqmandel_run dynamic resizing
 */	
static int liqmandel_run_resize(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float iw=((float)self->w);
	float ih=((float)self->h);
	
	liqcell *backplane = liqcell_child_lookup(self, "backplane");
	liqcell *title = liqcell_child_lookup(self, "title");
	liqcell *cmdreset = liqcell_child_lookup(self, "cmdreset");
	liqcell_setrect( backplane, iw*0.000,ih*0.000, iw*1.000,ih*1.002);
	liqcell_setrect( title, iw*0.000,ih*0.000, iw*1.000,ih*0.081);
	liqcell_setrect( cmdreset, iw*0.777,ih*0.000, iw*0.109,ih*0.081);
	mand_prep(canvas.cr);
	return 0;
}

/**	
 * liqmandel_run dynamic layout
 */	
static int liqmandel_run_layout(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float ww=canvas.pixelwidth;
	float hh=canvas.pixelheight;
	liqcell_setrect(self,		0,0,  ww,hh);
	return 0;
}
/**	
 * liqmandel_run.cmdreset clicked
 */	
static int cmdreset_click(liqcell *self,liqcellclickeventargs *args, liqcell *liqmandel_run)
{
	cx=0;
	cy=0;
	magx=4;
	magy=4;
	mand_prep(canvas.cr);
	return 0;
}
/**	
 * liqmandel_run_child_test_seek this function shows how to access members
 */	
	  
static void liqmandel_run_child_test_seek(liqcell *liqmandel_run)
{	  
	liqcell *backplane = liqcell_child_lookup(liqmandel_run, "backplane");
	liqcell *title = liqcell_child_lookup(liqmandel_run, "title");
	liqcell *cmdreset = liqcell_child_lookup(liqmandel_run, "cmdreset");
}	  
/**	
 * create a new liqmandel_run widget
 */	
liqcell *liqmandel_run_create()
{

	cx=0;
	cy=0;
	magx=4;
	magy=4;
	mand_prep(canvas.cr);


	liqcell *self = liqcell_quickcreatewidget("liqmandel_run", "form", 800, 480);
	if(!self) {liqapp_log("liqcell error not create 'liqmandel_run'"); return NULL;  } 
	
	// Optimization:  The aim is to REDUCE the number of drawn layers and operations called.
	// Optimization:  use only what you NEED to get an effect
	// Optimization:  Minimal layers and complexity
	// Optimization:  defaults: background, prefer nothing, will be shown through if there is a wallpaper
	// Optimization:  defaults: text, white, very fast rendering
	//############################# backplane:label
	liqcell *backplane = liqcell_quickcreatevis("backplane", "label", 0, 0, 800, 480);
	liqcell_setfont(	backplane, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (12), 0) );
	liqcell_setcaption(backplane, "backplane" );
	liqcell_propsets(  backplane, "textcolor", "rgb(255,0,0)" );
	liqcell_propsets(  backplane, "backcolor", "rgb(64,64,64)" );
	liqcell_propseti(  backplane, "textalign", 2 );
	liqcell_propseti(  backplane, "textaligny", 2 );
	liqcell_child_append(  self, backplane);
	liqcell_setvisible(backplane,0);
	//############################# title:label
	liqcell *title = liqcell_quickcreatevis("title", "label", 0, 0, 800, 38);
	liqcell_setfont(	title, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (29), 0) );
	liqcell_setcaption(title, "Mandelbrot" );
	liqcell_propsets(  title, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  title, "backcolor", "xrgb(128,128,128)" );
	liqcell_propseti(  title, "textalign", 0 );
	liqcell_propseti(  title, "textaligny", 0 );
	liqcell_child_append(  self, title);
	liqcell_setvisible(title,0);
	//############################# cmdreset:label
	liqcell *cmdreset = liqcell_quickcreatevis("cmdreset", "label", 622, 0, 86, 38);
	liqcell_setfont(	cmdreset, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (29), 0) );
	liqcell_setcaption(cmdreset, "reset" );
	liqcell_propsets(  cmdreset, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  cmdreset, "backcolor", "xrgb(0,64,64)" );
	liqcell_propsets(  cmdreset, "bordercolor", "rgb(255,255,255)" );
	liqcell_propseti(  cmdreset, "textalign", 2 );
	liqcell_propseti(  cmdreset, "textaligny", 2 );
	liqcell_handleradd_withcontext(cmdreset, "click", (void*)cmdreset_click, self );
	liqcell_child_append(  self, cmdreset);
	//liqcell_propsets(  self, "backcolor", "rgb(0,0,0)" );
	//liqcell_setimage(  self ,  liqimage_cache_getfile( "/usr/share/liqbase/liqmandel/media/liqmandel_run_back.png",0,0,0) );
	liqcell_handleradd_withcontext(self, "filter",		 (void*)liqmandel_run_filter ,self);
	liqcell_handleradd_withcontext(self, "refresh",		(void*)liqmandel_run_refresh ,self);
	liqcell_handleradd_withcontext(self, "shown",		  (void*)liqmandel_run_shown ,self);
	liqcell_handleradd_withcontext(self, "resize",	  (void*)liqmandel_run_resize ,self);
	liqcell_handleradd_withcontext(self, "layout",	  (void*)liqmandel_run_layout ,self);
	//liqcell_handleradd_withcontext(self, "keypress",	(void*)liqmandel_run_keypress,self );
	//liqcell_handleradd_withcontext(self, "keyrelease", (void*)liqmandel_run_keyrelease ,self);
	liqcell_handleradd_withcontext(self, "mouse",		(void*)liqmandel_run_mouse,self );
	//liqcell_handleradd_withcontext(self, "click",		(void*)liqmandel_run_click ,self);
	liqcell_handleradd_withcontext(self, "paint",		(void*)liqmandel_run_paint ,self); // use only if required, heavyweight
	liqcell_handleradd_withcontext(self, "dialog_open",  (void*)liqmandel_run_dialog_open ,self);
	liqcell_handleradd_withcontext(self, "dialog_close", (void*)liqmandel_run_dialog_close ,self);
	return self;
}

