// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>



//#####################################################################
//#####################################################################
//##################################################################### liqaccelview_trace :: by gary birkett
//#####################################################################
//#####################################################################
		
		
/**	
 * liqaccelview_trace widget refresh, all params set, present yourself to the user.
 */	
static int liqaccelview_trace_refresh(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	// there might be an OS level variable called filter
	// it should be set and adjusted correctly prior to calling this routine
	// you should do your best to account for this filter in any way you see fit
	return 0;
}
/**	
 * liqaccelview_trace dialog_open - the user zoomed into the dialog
 */	
static int liqaccelview_trace_dialog_open(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqaccelview_trace dialog_close - the dialog was closed
 */	
static int liqaccelview_trace_dialog_close(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqaccelview_trace widget shown - occurs once per lifetime
 */	
static int liqaccelview_trace_shown(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqaccelview_trace mouse - occurs all the time as you stroke the screen
 */	
static int liqaccelview_trace_mouse(liqcell *self, liqcellmouseeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqaccelview_trace click - occurs when a short mouse stroke occured
 */	
static int liqaccelview_trace_click(liqcell *self, liqcelleventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqaccelview_trace keypress - the user pressed a key
 */	
static int liqaccelview_trace_keypress(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqaccelview_trace keyrelease - the user released a key
 */	
static int liqaccelview_trace_keyrelease(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}

/**	
 * liqaccelview_trace paint - being rendered.  use the vgraph held in args to do custom drawing at scale
 */	
static int liqaccelview_trace_paint(liqcell *self, liqcellpainteventargs *args,liqcell *context)
{

	liqcell *backplane = liqcell_child_lookup(self, "backplane");
		liqcell *canvas = liqcell_child_lookup(backplane, "canvas");

    liqsketch *sketch = liqcell_getsketch(canvas);
    if(!sketch)
    {
        sketch = liqsketch_new();
		if(!sketch)
		{
			liqapp_log("liqsketchedit_save_click nothing to save");
			return 0;
		}
					
        sketch->pixelwidth =32767;
        sketch->pixelheight=0;
        
        sketch->dpix=225;	// damn, dont like using this here
        sketch->dpiy=225;
        
        
		if(!sketch)
		{
			liqapp_log("liqsketchedit_save_click nothing to save");
			return 0;
		}
        
        canvas->x=backplane->w;
        canvas->w=0;
        
        liqcell_setsketch(canvas,sketch);
    }
    
    #define ssss 5
    
    sketch->pixelheight+=ssss;
    
	int aax=0;
	int aay=0;
	int aaz=0;
	
	liqaccel_read(&aax,&aay,&aaz);
    
    unsigned long 	mt=liqapp_GetTicks();
    
    aax = 200 + (aax*400/2400);
    aay = 200 + (aay*400/2400);
    aaz = 200 + (aaz*400/2400);
    
    liqstroke *stroke;
    
    //#################################
    stroke = sketch->strokefirst;
    if(!stroke)
    {
			stroke = liqstroke_new();
			stroke->pen_y = 255;
			stroke->pen_u = 128;
			stroke->pen_v = 128;
            liqstroke_start(stroke,canvas->w,aax,100,mt);
            liqsketch_strokeinsert(sketch,stroke);
    }
    else
    {
            liqstroke_start(stroke,canvas->w,aax,100,mt);
			liqsketch_strokeupdate(sketch,stroke);
    }
    
    //#################################
    stroke = stroke->linknext;
    if(!stroke)
    {
			stroke = liqstroke_new();
			stroke->pen_y = 255;
			stroke->pen_u = 30;
			stroke->pen_v = 128;
            liqstroke_start(stroke,canvas->w,aay,100,mt);
            liqsketch_strokeinsert(sketch,stroke);
    }
    else
    {
            liqstroke_start(stroke,canvas->w,aay,100,mt);
			liqsketch_strokeupdate(sketch,stroke);
    }    
    
    //#################################
    stroke = stroke->linknext;
    if(!stroke)
    {
			stroke = liqstroke_new();
			stroke->pen_y = 155;
			stroke->pen_u = 230;
			stroke->pen_v = 228;
            liqstroke_start(stroke,canvas->w,aaz,100,mt);
            liqsketch_strokeinsert(sketch,stroke);
    }
    else
    {
            liqstroke_start(stroke,canvas->w,aaz,100,mt);
			liqsketch_strokeupdate(sketch,stroke);
    }    
    
    
         
    canvas->x-=ssss;
    canvas->w+=ssss;
    
    
    
    liqcell_setdirty(self,1);

	// big heavy event, use sparingly
	return 0;
}

/**	
 * liqaccelview_trace dynamic resizing
 */	
static int liqaccelview_trace_resize(liqcell *self,liqcelleventargs *args, liqcell *context)
{
/*	float sx=((float)self->w)/((float)self->innerw);
	float sy=((float)self->h)/((float)self->innerh);
	
	liqcell *backplane = liqcell_child_lookup(self, "backplane");
		liqcell *canvas = liqcell_child_lookup(backplane, "canvas");
	liqcell *liqanimframecounter1 = liqcell_child_lookup(self, "liqanimframecounter1");
	liqcell *label1 = liqcell_child_lookup(self, "label1");
	liqcell *cmdrecordstop = liqcell_child_lookup(self, "cmdrecordstop");
	liqcell *title = liqcell_child_lookup(self, "title");
	liqcell_setrect_autoscale( cmdrecordstop, 652,432, 148,48, sx,sy);
	liqcell_setrect_autoscale( title, 0,0, 800,38, sx,sy);
	liqcell_setrect_autoscale( liqanimframecounter1, 54,432, 594,48, sx,sy);
	liqcell_setrect_autoscale( label1, 606,0, 136,36, sx,sy);
	liqcell_setrect_autoscale( backplane, 0,40, 800,388, sx,sy);
	liqcell_setrect_autoscale( canvas, 584,0, 216,388, sx,sy);
*/	return 0;
}

/**	
 * liqaccelview_trace.cmdrecordstop clicked
 */	
static int cmdrecordstop_click(liqcell *self,liqcelleventargs *args, liqcell *liqaccelview_trace)
{
    // get the accelerometer data
    // and add it to a sketch
    
    
    
	return 0;
}
/**	
 * liqaccelview_trace_child_test_seek this function shows how to access members
 */	
	  
static void liqaccelview_trace_child_test_seek(liqcell *self)
{	  
	liqcell *backplane = liqcell_child_lookup(self, "backplane");
		liqcell *canvas = liqcell_child_lookup(backplane, "canvas");
	//liqcell *liqanimframecounter1 = liqcell_child_lookup(self, "liqanimframecounter1");
	//liqcell *label1 = liqcell_child_lookup(self, "label1");
	//liqcell *cmdrecordstop = liqcell_child_lookup(self, "cmdrecordstop");
	liqcell *title = liqcell_child_lookup(self, "title");
}	  
/**	
 * create a new liqaccelview_trace widget
 */	
liqcell *liqaccelview_trace_create()
{
	liqcell *self = liqcell_quickcreatewidget("liqaccelview_trace", "form", 800, 480);
	if(!self) {liqapp_log("liqcell error not create 'liqaccelview_trace'"); return NULL;  } 
	
	// Optimization:  The aim is to REDUCE the number of drawn layers and operations called.
	// Optimization:  use only what you NEED to get an effect
	// Optimization:  Minimal layers and complexity
	// Optimization:  defaults: background, prefer nothing, will be shown through if there is a wallpaper
	// Optimization:  defaults: text, white, very fast rendering
	//############################# backplane:picturebox
	liqcell *backplane = liqcell_quickcreatevis("backplane", "picturebox", 0, 40, 800, 440);
	//liqcell_setfont(	backplane, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (12), 0) );
	//liqcell_propsets(  backplane, "textcolor", "rgb(0,0,0)" );
	//liqcell_propsets(  backplane, "backcolor", "rgb(128,128,128)" );
		//############################# canvas:label
		liqcell *canvas = liqcell_quickcreatevis("canvas", "label", 584, 0, 216, 440);
		//liqcell_setfont(	canvas, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (12), 0) );
		//liqcell_setcaption(canvas, "canvas" );
		//liqcell_propsets(  canvas, "textcolor", "rgb(255,0,0)" );
		//liqcell_propsets(  canvas, "backcolor", "rgb(64,64,64)" );
		//liqcell_propseti(  canvas, "textalign", 2 );
        liqcell_propseti( canvas ,  "lockaspect", 0 );
        liqcell_propseti(canvas,"sketchediting",1);
		liqcell_child_append(  backplane, canvas);
	liqcell_child_append(  self, backplane);
	

	//############################# title:label
	liqcell *title = liqcell_quickcreatevis("title", "label", 0, 0, 800, 38);
	liqcell_setfont(	title, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (29), 0) );
	liqcell_setcaption(title, "Accelerometer tracing (hey Roger S \\o)" );
	liqcell_propsets(  title, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  title, "backcolor", "xrgb(128,128,128)" );
	liqcell_propseti(  title, "textalign", 0 );
	liqcell_child_append(  self, title);
	liqcell_propsets(  self, "backcolor", "rgb(0,0,0)" );
	liqcell_handleradd_withcontext(self, "refresh", liqaccelview_trace_refresh ,self);
	liqcell_handleradd_withcontext(self, "shown", liqaccelview_trace_shown ,self);
	liqcell_handleradd_withcontext(self, "resize", liqaccelview_trace_resize ,self);
	liqcell_handleradd_withcontext(self, "keypress", liqaccelview_trace_keypress,self );
	liqcell_handleradd_withcontext(self, "keyrelease", liqaccelview_trace_keyrelease ,self);
	liqcell_handleradd_withcontext(self, "mouse", liqaccelview_trace_mouse,self );
	liqcell_handleradd_withcontext(self, "click", liqaccelview_trace_click ,self);
	liqcell_handleradd_withcontext(self, "paint", liqaccelview_trace_paint ,self); // use only if required, heavyweight
	liqcell_handleradd_withcontext(self, "dialog_open", liqaccelview_trace_dialog_open ,self);
	liqcell_handleradd_withcontext(self, "dialog_close", liqaccelview_trace_dialog_close ,self);
	return self;
}

