/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/

#ifndef USER_H
#define USER_H

#include <QObject>
#include <QStringList>
#include <QHash>

class User : public QObject
{
    Q_OBJECT
public:
    explicit User(QObject *parent = 0);
	~User();

	Q_INVOKABLE void setCompaniesFollowed(QString xml);
	Q_INVOKABLE bool following(QString id);
	Q_INVOKABLE int numFollowing();
	Q_INVOKABLE void follow(QString id, QString name);
	Q_INVOKABLE void stopFollow(QString id);
	Q_INVOKABLE QString getCompanyQuery();

	Q_INVOKABLE void setPeopleConnections(QString xml);
	Q_INVOKABLE bool connected(QString id);
	Q_INVOKABLE void addConnection(QString id, QString firstName);
	Q_INVOKABLE void removeConnection(QString id);

	Q_INVOKABLE void setJobsBookmarked(QString xml);
	Q_INVOKABLE bool bookmarked(QString id);
	Q_INVOKABLE void bookmark(QString id, QString firstName);
	Q_INVOKABLE void removeBookmark(QString id);

	void print();


private:
	QHash<QString,QString>* companiesFollowed;
	QHash<QString,QString>* peopleConnections;
	QHash<QString,QString>* jobsBookmarked;

};

#endif // USER_H
