/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0

XmlListModel{
	id: root

	query: "/updates/update"

	XmlRole { name: "updateType"; query: "update-type/string()"; isKey: true}


	XmlRole { name: "id"; query: "update-content/person/id/string()"; isKey: true}
	XmlRole { name: "firstName"; query: "update-content/person/first-name/string()"; isKey: true }
	XmlRole { name: "lastName"; query: "update-content/person/last-name/string()"; isKey: true }
	XmlRole { name: "headline"; query: "update-content/person/headline/string()"; isKey: true}
	XmlRole { name: "pictureUrl"; query: "update-content/person/picture-url/string()"; isKey: true }

	XmlRole { name: "newId"; query: "update-content/person/connections/person/id/string()"; isKey: true}
	XmlRole { name: "newFirstName"; query: "update-content/person/connections//person/first-name/string()"; isKey: true }
	XmlRole { name: "newLastName"; query: "update-content/person/connections//person/last-name/string()"; isKey: true }
	XmlRole { name: "newHeadline"; query: "update-content/person/connections//person/headline/string()"; isKey: true}
	XmlRole { name: "newPictureUrl"; query: "update-content/person/connections//person/picture-url/string()"; isKey: true }
	XmlRole { name: "newIndustry"; query: "update-content/person/connections//person/industry/string()"; isKey: true}


}
