/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0

XmlListModel{
	id:model
	query: "/person"

	XmlRole {name: "id"; query: "id/string()"}

	XmlRole {name: "firstName"; query: "first-name/string()"}
	XmlRole {name: "lastName"; query: "last-name/string()"}
	XmlRole {name: "pictureUrl"; query: "picture-url/string()"}
	XmlRole {name: "headline"; query: "headline/string()"}
	XmlRole {name: "location"; query: "location/name/string()"}
	XmlRole {name: "specialties"; query: "specialties/string()"}
	XmlRole {name: "interests"; query: "interests/string()"}
	XmlRole {name: "summary"; query: "summary/string()"}
	XmlRole {name: "industry"; query: "industry/string()"}
	XmlRole {name: "honors"; query: "honors/string()"}
	XmlRole {name: "associations"; query: "associations/string()"}

}
