/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "../components"


Column{
    id: root
    opacity: PathView.opacity
    scale: PathView.scale
    z: PathView.z

	function click(){
		button.clicked(false)
	}

        Button{
            id: button
            iconSource: icon
            smooth: true
//            onPressAndHold: Notifier.longNotify(tip)
            onClicked: {
					if(PathView.opacity === 1 && create){
                        window.clicked()
                        var comp = Qt.createComponent("../" + create)
                        var object = comp.createObject(window.parent);
                        if(profileID)
                            object.profileID = profileID
						if(name === "News")
							object.searchStringChanged() //cause news to be retrieved for all followed companies
                        object.caller = window
                    }


            }

            Text {
                text: name;
                anchors.horizontalCenter: parent.horizontalCenter;
                color: palette.text;
                font.pixelSize: 24
                anchors.bottom: parent.top
                anchors.margins: 45
				opacity: PathView.opacity === 1 ? 1 : 0
                Behavior on opacity {NumberAnimation {duration: 250}}
            }

            Text {
                text: tip
                anchors.horizontalCenter: parent.horizontalCenter;
                anchors.top: parent.bottom
                width: root.parent.width*.8
                wrapMode: Text.Wrap
                horizontalAlignment: Text.Center
                color: palette.text;
                font.pixelSize: 20
                anchors.margins: 10

				opacity: PathView.opacity === 1 ? 1 : 0
                Behavior on opacity {NumberAnimation {duration: 250}}

                SequentialAnimation{
                    running: PathView.opacity === 1 ? 1 : 0
                    NumberAnimation { target: button; property: "scale"; to: 1.1; duration: 100}
                    NumberAnimation { target: button; property: "scale"; to: 1; duration: 100 }
                }


            }

    }
}

