/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0


Item{
	id: root
	width:  parent.width
	height: button.shown ? button.height + list.height : button.height


	property alias expandedWidth: background.width
	property alias backgroundColor: background.color
	property int duration: 500

	property alias model: list.model
	property Component delegate
	property alias count: list.count
	property alias text: button.text

	property alias orientation: list.orientation
	property alias interactive: list.interactive
	property alias snapMode: list.snapMode
	property alias listClip: list.clip
	property alias listSpacing: list.spacing
	property alias cacheBuffer: list.cacheBuffer
	property alias flickDeceleration: list.flickDeceleration

	Behavior on height { PropertyAnimation{easing.type: Easing.InOutCubic; duration: root.duration}}

	SystemPalette{id:palette}

	SectionButton{
		id: button
		shown: true

		Item{
			z:-1
			anchors.fill: parent
			anchors.bottomMargin: -background.height
			clip: true

			ListView{
				id: list

				height: contentHeight
				anchors.left: parent.left
				anchors.right: parent.right
				anchors.top: parent.top
				anchors.topMargin: -height
				anchors.leftMargin: 20
				anchors.rightMargin: 20
				spacing: 30
				interactive: false
				delegate: root.delegate

				Behavior on anchors.topMargin {PropertyAnimation{easing.type: Easing.InOutCubic; duration: root.duration} }


				Rectangle{
					id: background


					anchors.fill: list
					anchors.leftMargin: -10
					anchors.rightMargin: -10
					anchors.topMargin: -10
					anchors.bottomMargin: -10
					color: palette.dark
					radius: 5
					z:-2
				}

				states: [
					State {
						name: "shown"
						when: button.shown
						PropertyChanges {target: list; anchors.topMargin: button.height}
					}
				]

			}
		}

	}
}
