/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "../components"



Row{
	id: root

	signal changePage(string start, string count)

	property string count:  "10"
	property int pages: Math.ceil(parseFloat(numResults/parseInt(root.count))) //10 items per page

	Repeater{
		id: repeater
		model: Math.min(root.pages, 10)
		signal check(int indx)

		delegate: Button{
			id: button
			height: 80
			checkable: true

			property string count: root.count
			property string start: (index*parseInt(count)).toString()
			property int buttonIndex : index

			onClicked: {
				root.changePage(start,count)
				repeater.check(index)
			}

			Component.onCompleted: {
				if(index === 0)
					checked = true
			}

			text: (index+1).toString()
			Connections{
				target: repeater
				onCheck: {
					if(indx !== button.buttonIndex){
						button.checked = false
					}

				}
			}
		}


	}
}


