/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "../components"

Item {
	id: root
	width: toggleButton.width
	height: Math.max(toggleButton.height, commentBox.height+toggleButton.height)

	property alias commentable: button.commentable
	property alias key: button.key
	property int expandedWidth

	property alias placeholderText: textArea.placeholderText

	signal requestStarted
	signal commentSent(string status)

	Button{
		id: toggleButton
		iconSource: button.iconSource
		z:100
		onClicked: {
			if(!wasHeld)
				root.state = root.state === "shown" ? "":"shown"
		}

		onPressAndHold: Notifier.longNotify("Comment:\n\nComment on this item")
	}


	Item{
		id: commentBox
		width: expandedWidth
		anchors.left: parent.left
		anchors.top: parent.top
		anchors.leftMargin: -toggleButton.width
		anchors.topMargin: toggleButton.height
		Behavior on opacity {NumberAnimation{duration:250}}
		Behavior on height {NumberAnimation{duration:250}}

		height: 0
		opacity: 0

		TextArea{
			id: textArea
			anchors.fill: parent
			placeholderText: "Enter a Comment!"
			anchors.rightMargin: button.width
		}

		CommentButton{
			id: button
			anchors.right: parent.right
			anchors.bottom: parent.bottom
			commentStr: textArea.text
			onRequestStarted: root.requestStarted()
			onCommentSent: {
				root.commentSent(status)
				if(status === "201"){
					textArea.placeholderText = "Successfuly sent!"
					textArea.text = ""
					button.focus = true
					root.state = ""
				}

			}
		}

	}





	states: [
		State {
			name: "shown"
			PropertyChanges {target: commentBox; opacity: 1; height: 200}
		}
	]
}
