/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "updates"
import "components"

Window {
	id: root
	border: false


	SystemPalette{id: palette}


	NewConnections{
		id: connections
		anchors.fill: parent
		anchors.bottomMargin: buttonBox.height
		visible: false
		caller: root.caller
		onBack: root.close()
	}

	Shares{
		id: shares
		anchors.fill: parent
		anchors.bottomMargin: buttonBox.height
		visible: false
		caller: root.caller
		onBack: root.close()
	}


	Rectangle{
		id: buttonBox
		state:  "profile"
		width: parent.width
		height: row.height
		color: palette.dark
		anchors.bottom: parent.bottom
		Row{
			id: row
			Button{
				id: profileButton
				iconSource: "qrc:///qml/images/user-small.png"
				onClicked: buttonBox.state = "profile"
			}
			Button{
				id: connectionsButton
				iconSource: "qrc:///qml/images/link-small.png"
				onClicked: buttonBox.state = "connections"
			}
		}


		states: [
			State {
				name: "profile"
				PropertyChanges {target: shares; visible: true}
			},
			State {
				name: "connections"
				PropertyChanges {target: connections; visible: true}
			}
		]


	}


}
