/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "status"
import "common"

Item {
	id: root
	width: parent.width; height: list.height


	onProfileIDChanged: {
		get(API.get_person_by_id(profileID))
	}

	function get(url){
		var xmlHttp = new XMLHttpRequest();
		xmlHttp.onreadystatechange = function(){
			if(xmlHttp.readyState == 4)
				profileXML = xmlHttp.responseText;
		}
		xmlHttp.open( "GET", url, true );
		xmlHttp.send( null );
	}


	property string profileID
	property string profileXML
	property alias shown: button.state
	signal posted

	SystemPalette{id: palette}

	XmlListModel{
		id:model
		query: "/person"
		xml: profileXML

		onSourceChanged: {
			if(model.status == XmlListModel.Ready)
				console.log(model.source)
		}

		XmlRole {name: "firstName"; query: "first-name/string()"}
		XmlRole {name: "lastName"; query: "last-name/string()"}
		XmlRole {name: "pictureUrl"; query: "picture-url/string()"}
	}

	RotatingButton{
		id: button
		width: 50
		anchors.bottom: list.top
		anchors.horizontalCenter: parent.horizontalCenter
	}

	Rectangle{
		id: background
		anchors.fill: list
		z: -1
		color:  palette.dark
	}

	ListView{
		id: list
		model: model
		height: 150
		anchors.left: parent.left
		anchors.right: parent.right
		interactive: false
		delegate: StatusDelegate{
			Connections{
				onPosted: root.posted()
			}
		}
		Behavior on y{ PropertyAnimation{target: list; property: "y"; easing.type: Easing.OutExpo; duration: 500} }

	}

	states: [
		State {
			name: "hidden"
			when:  button.state !== ""
			PropertyChanges {target: list; y: list.height}
		}
	]
}
