/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "components"
import "search"
import "profile"
import "home"

/*The home screen in which other screens are launched*/
Window {
	id: window
	width: parent.width
	height: parent.height
	borderTitle: "Home"
	z:100
	isRoot: true

	signal clicked()

	onFocusChanged: {
		if(focus){
			focus = false
			pathView.focus = true
		}
	}

//	Component.onCompleted: Notifier.notify("Tip: If you don't know what a button does, press and hold it for an explanation!")

	Path{
		id: circular
		startX: window.width*.5; startY: window.height*.5

		PathAttribute{ name: "opacity"; value: 1}
		PathAttribute{ name: "scale"; value: 1}
		PathAttribute{ name: "z"; value: 1}
		PathQuad {
			x: window.width*.5 ; y: window.height*.20
			controlX: window.width+100; controlY: window.height*.35
		}

		PathAttribute{ name: "opacity"; value: .2}
		PathAttribute{ name: "scale"; value: .3}
		PathAttribute{ name: "z"; value: 0}
		PathQuad {
			x: window.width*.5 ; y: window.height*.5
			controlX: -100; controlY: window.height*.35
		}
	}

	Path{
		id: linear
		startX:0; startY: window.height*.5

		PathAttribute{ name: "opacity"; value: .2}
		PathAttribute{ name: "scale"; value: .3}
		PathAttribute{ name: "z"; value: 0}


		PathLine {
			x: window.width*.5 ; y: window.height*.5
		}
		PathPercent{value: .25}

		PathAttribute{ name: "opacity"; value: 1}
		PathAttribute{ name: "scale"; value: 1}
		PathAttribute{ name: "z"; value: 1}
		PathLine {
			x: window.width ; y: window.height*.5
		}
		PathPercent{value: .5}


	}

	PathView{
		id: pathView
		anchors.fill: parent
		focus: true
		clip: true
		signal click

		preferredHighlightBegin: .5
		preferredHighlightEnd: .5


		Keys.onLeftPressed: decrementCurrentIndex()
		Keys.onRightPressed: incrementCurrentIndex()
		Keys.onEnterPressed: pathView.click()
		Keys.onReturnPressed: pathView.click()

		highlightMoveDuration: 100
		model:  HomeModel{}
		delegate: HomeDelegate{
			Connections{
				target: pathView
				onClick: click()
			}

		}
		path:circular

	}


}
