/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "finance"
import "finance/NASDAQ.js" as NASDAQ

Window {
	id: root
	width: parent.width
	height: parent.height
	busy: true

	property string ticker

	//	borderTitle: "Finance"
	imgSource: "qrc:///qml/images/nasdaq.png"

	onTickerChanged: get("http://quotes.nasdaq.com/asp/SummaryQuote.asp?symbol=" + root.ticker)
	onGetFinished: {
		var quote = NASDAQ.parseQuotes(xml)
		if(quote)
			nasdaqText.text = quote
		else{
			var object = notFound.createObject(root)
		}

		graph.source = NASDAQ.parseGraph(xml)
	}


	Flickable{
		contentHeight: nasdaqText.height + graph.height + 20
		contentWidth: nasdaqText.width
		anchors.fill: parent
		anchors.topMargin: borderHeight
		flickableDirection: Flickable.VerticalFlick

		Text {
			id: nasdaqText
			width: root.width
			horizontalAlignment: Text.Center
			onLinkActivated: Qt.openUrlExternally(link)
			color: palette.text
			states: [
				State {
					when: root.width > root.height
					PropertyChanges {target: nasdaqText; font.pixelSize: 24}
					PropertyChanges {target: graph; height: height*2}
				}
			]
		}
		Image {
			id: graph
			smooth: true
			anchors.top: nasdaqText.bottom
			anchors.left: parent.left
			anchors.right: parent.right
			//				fillMode: Image.PreserveAspectCrop
		}
	}


	Component{
		id: notFound
		Text {
			text: "The ticker symbol '"+root.ticker+"' was not found in the NASDAQ databse, sorry"
			font.pixelSize: 22
			color: palette.text
			wrapMode: Text.Wrap
			anchors.horizontalCenter: parent.horizontalCenter
			anchors.verticalCenter: parent.verticalCenter
			width: parent.width
			horizontalAlignment: Text.Center
			Image {
				id: name
				source: "qrc:///qml/images/star-off.png"
				anchors.bottom: parent.top
				anchors.horizontalCenter: parent.horizontalCenter
			}
		}
	}



}
