/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of lightmeter.

    lightmeter is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    lightmeter is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with lightmeter.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

namespace Ui
{
    class MainWindowClass;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    Ui::MainWindowClass *ui;
    QStringList apertureList;
    QStringList speedList;
    enum Mode { APERTURE, SPEED };
    Mode mode;
    void timerEvent(QTimerEvent *event);
    double aperture;
    double iso;
    double speed;
    QString apertureString;
    QString isoString;
    QString speedString;
    void readSettings();
    int findNearestListElement(double value, QStringList list);

public slots:
    void speedHandler(QString value);
    void apertureHandler(QString value);
    void isoHandler(QString value);
    void editSettings();
    void storeExp();
    void openAboutDialog();
};

#endif // MAINWINDOW_H
