/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

import "Themes.js" as Themes
import "Settings.js" as Settings
import "main.js" as Script

Item {
     id: screen
     width: 800
     height: 480

     state:"mainscreen"

     signal dialogClose

     property int curMonth: Script.curMonth
     property int curYear: Script.curYear

     Loader {
         id: theme_manager
         property alias theme: theme_manager.item
         source: Themes.default_theme()
     }

     Component.onCompleted: {
        Settings.restore_nomodel();
        Script.createDateTimeDialog(screen);
        Script.datetimedlg.toolbar.connect(show_toolbar);
        Script.datetimedlg.updatedate.connect(update_date);
        Script.amdatetimedlg.toolbar.connect(show_toolbar);
        Script.amdatetimedlg.updatedate.connect(update_date);
        Script.fullmonth.toolbar.connect(show_toolbar);
        Script.fullmonth.updatedate.connect(update_date);
        maindatemodel.init();
        Script.init();
     }

     function show_toolbar(){
        screen.state="mainscreen";
     }

     function update_date(day, month, year){
         txtDATEpv.currentIndex = day-1;
         screen.curMonth = month;
         screen.curYear = year;
         Script.curMonth = month;
         Script.curYear = year;
         Script.changeDay(day, txtTHU, txtInfo, txtDAYAmLich);
         Script.fullmonth.m_day=Script.curDay;
         Script.fullmonth.m_month=Script.curMonth;
         Script.fullmonth.m_year=Script.curYear;
         Script.fullmonth.reset();
         maindatemodel.reset();
     }

     Rectangle {
         id: mecal
         anchors.fill: parent
         color: "white"

         state:"jumptodate"

         Image {
             source: theme_manager.theme.background_image; fillMode: Image.Stretch; anchors.fill: parent
             opacity: theme_manager.theme.background_opacity
         }


         MouseArea {
             id:mouseareaMM
             property int  xfrom: 0
             property int  yfrom: 0

             property int fixed: 40
             property int rise: 0

             anchors.fill: parent;anchors.topMargin: 60;anchors.bottomMargin:60;

             onPressAndHold:{
                 if (Settings.pressandhold()==1){
                     menu_item_Clicked(4);
                 }
             }

             onDoubleClicked:{

                 if (Settings.doubleclicked()==1){
                     screen.state="switchX";
                    Script.datetimedlg.state="show";
                 }
             }
         }

         //------------------------------------------------

                  Rectangle {
                      id:reelx
                      width: 260
                      height: 90
                      y: 116
                      anchors.horizontalCenter: parent.horizontalCenter
                      property int index: 0
                      onIndexChanged: txtDATEpv.currentIndex = reelx.index
                      color: "transparent"

                      Component {
                          id: delegate
                          Column {
                              id: wrapper
                              Text {
                                  id: nameText
                                  text: name
                                  font.bold: true
                                  font.pixelSize: wrapper.PathView.isCurrentItem ? 80 : 40
                                  color: {
                                      if (wrapper.PathView.isCurrentItem){
                                          var stemp = Script.convertSolar2Lunar(txtDATEpv.currentIndex+1,curMonth,curYear,7);
                                          if (Script.is_holiday(txtDATEpv.currentIndex+1,curMonth, stemp[0], stemp[1])){
                                              return theme_manager.theme.markdate.holidays;
                                          }else{
                                          var mark_day = (Script.getLunarDate(txtDATEpv.currentIndex+1,curMonth,curYear).jd+1)%7;
                                          if (mark_day === 0) //sunday
                                              return theme_manager.theme.markdate.sunday;
                                          if (mark_day == 6) //saturday
                                              return theme_manager.theme.markdate.saturday;
                                          else
                                              return  theme_manager.theme.markdate.otherday_selected;
                                          }
                                      }
                                      else
                                          return "transparent";//theme_manager.theme.markdate.otherday;
                                    }
                              }
                          }
                      }

                      PathView {
                          id:txtDATEpv
                          anchors.fill: parent
                          model: maindatemodel
                          delegate: delegate
                          pathItemCount: 3
                          clip: true
                          Keys.onLeftPressed: decrementCurrentIndex()
                          Keys.onRightPressed: incrementCurrentIndex()
                          highlightMoveDuration:500
                          preferredHighlightBegin: 0.5
                          preferredHighlightEnd: 0.5
                          highlightRangeMode: PathView.StrictlyEnforceRange
                          focus: true
                          interactive: true
                          highlight: Rectangle{
                              anchors.topMargin: 10;
                              width:110;
                              height:80;
                              radius: 8;
                              color:"#000000"
                              opacity: 0.3
                          }
                          path: Path {
                              startX: 0
                              startY: 50
                              PathLine {x: reelx.width; y: 50}
                          }

                          onMovementStarted:{

                          }

                          onMovementEnded: {
                              Script.changeDay(txtDATEpv.currentIndex+1, txtTHU, txtInfo, txtDAYAmLich);
                              Script.fullmonth.m_day=Script.curDay;
                              Script.fullmonth.m_month=Script.curMonth;
                              Script.fullmonth.m_year=Script.curYear;
                              Script.fullmonth.reset();
                          }
                      }
                  }
                  ListModel {
                      id:maindatemodel

                      function reset(){
                          var days_of_this_month = Script.calDays();
                          var days_of_changes = days_of_this_month - maindatemodel.count;

                          var ifs;

                          if (days_of_changes<0){
                              ifs=Math.abs(days_of_changes);
                              while(ifs>0){
                                  maindatemodel.remove(maindatemodel.count-1);
                                  ifs-=1;
                              }
                          }else if(days_of_changes>0){
                              ifs=maindatemodel.count;
                              for (var i=1;i<=days_of_changes;i++)
                                  append({name:i+ifs})
                          }

                         reelx.index = -1;
                         reelx.index = Script.curDay - 1;

                      }

                      function init(){
                          for(var i=1;i<=Script.calDays();i++)
                              append({name:i});

                          reelx.index = Script.curDay - 1;
                      }
                  }

         //-------------------------------------------------

         Text {
             id: txtDMY
                      x: 151
                      y: 77
                      height: 20
                      color: "#29d999"
                      text: "Tháng <b>"+screen.curMonth+"</b> Năm <b>"+screen.curYear+"</b>"
                      horizontalAlignment: Text.AlignHCenter
                      anchors.horizontalCenter: parent.horizontalCenter
                      font.bold: false
                      font.family: "Tahoma"
                      smooth: true
                      font.pixelSize: 28
              }

         Text {
             id: txtTHU
             x: 151
             y: 210
             height: 20
             color: "#f0f0f5"
             text: Script.__txtTHU_format()
             horizontalAlignment: Text.AlignHCenter
             anchors.horizontalCenter: parent.horizontalCenter
             opacity: 0.6
             font.bold: true
             font.pixelSize: 30
         }

         Text {
             id: txtInfo
             x: 151
             y: (screen.is_holiday ? 270 : 250)
             height: 20
             color: (Script.is_holiday ? theme_manager.theme.markdate.holidays : theme_manager.theme.markdate.not_holidays)
             text: Script.__txtInfo_format()
             horizontalAlignment: Text.AlignHCenter
             anchors.horizontalCenter: parent.horizontalCenter
             opacity: 0.6
             font.bold: (screen.is_holiday ? true : false)
             font.pixelSize: (screen.is_holiday ? 25 : 20)
         }

         Text {

             id: txtDAYAmLich
             x: 151
             y: 330
             height: 20
             color: theme_manager.theme.markdate.lunardate
             text: Script.__txtDAYAmLich_format()
             horizontalAlignment: Text.AlignHCenter
             anchors.horizontalCenter: parent.horizontalCenter
             opacity: 0.6
             font.bold: true
             font.pixelSize: 25
         }

         ToolBar { id: toolBar; height: 42;
             y: screen.height - 52
             width: parent.width; opacity: 0.8
             button1Label: "Menu"
             button2Label: "Lựa Chọn"
             onButton1Clicked:
             {
                 screen.state="switchX"
                 var menuscreen = Script.createObject("MenuScreen.qml", screen);
                 menuscreen.close.connect(closeDialogs);
                 menuscreen.item_click.connect(menu_item_Clicked);
                 menuscreen.state = "show";
             }
             onButton2Clicked: {
                 screen.state="switchX"
                 var optionsscreen = Script.createObject("OptionsScreen.qml", screen);
                 optionsscreen.close.connect(closeDialogs);
                 optionsscreen.state = "show";
             }

         }

         MultiTitleBar { id: titleBar; width: parent.width }

     }

     function closeDialogs(){
         dialogClose();
         screen.state="mainscreen";
     }

     function menu_item_Clicked(id){
         var qmlF = "";
         if (id!=1)
            screen.state="switchX";
         switch(id){
            case 1: Script.reset_to_default_day(txtTHU, txtInfo, txtDAYAmLich);
                 txtDATEpv.currentIndex = Script.curDay-1;
                screen.curMonth = Script.curMonth;
                screen.curYear = Script.curYear;
                Script.fullmonth.m_day= Script.curDay-1;
                Script.fullmonth.m_month= Script.curMonth;
                Script.fullmonth.m_year= Script.curYear;
                break;
            case 2: Script.amdatetimedlg.state="show";break;
            case 3: Script.datetimedlg.state="show";break;
            case 4: qmlF="XemNgayTotXauHoangDao";break;
            case 5: Script.fullmonth.state="show";break;
            case 6: qmlF = "About";break;
            default:screen.state = "mainscreen";qmlF="";break;
         }
         if (qmlF){
             var qmlobj = Script.createObject(qmlF+".qml", screen);
             qmlobj.close.connect(closeDialogs);
             qmlobj.state = "show";
         }
     }

     states: [
         State {
             name:"mainscreen"
             StateChangeScript {
                 script:{
                 }
                }
         },
         State {
             name: "switchX";
             PropertyChanges { target: titleBar; y: -50 }
             PropertyChanges { target: toolBar; y: screen.height }
             PropertyChanges { target: toolBar }
             PropertyChanges { target: mouseareaMM;enabled:false }
         }
     ]

     transitions: [
         Transition { NumberAnimation { properties: "x,y,opacity"; duration: 300; easing.type: Easing.InOutBack } }
     ]

}
