/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

import "Themes.js" as Themes

Item{

    id:menuscreen

    anchors.verticalCenter: parent.verticalCenter
    width: parent.width; height: parent.height;
    x:-(parent.width * 1.5)

    signal close
    signal item_click(int pos)

    Loader {
        id: theme_manager
        property alias theme: theme_manager.item
        source: Themes.default_theme()
    }

    Connections {
        target: menuscreen.parent

        onDialogClose: {
            menuscreen.state = "close";
            menuscreen.destroy(600);
        }
    }

    Rectangle {
        id: rectangle1
        anchors.fill: parent; anchors.bottomMargin: 0;
        visible: true
        opacity:0.9

        Component {
                id: listDelegate
                Rectangle {
                    height:65
                MenuButton {
                     y: 3; width: parent.parent.width; height: 60
                    onClicked: {
                        getText(idm)
                    }
                    text: name
                    tip: title
                }
                }
            }

        ListModel {
                 id: listModel

                 ListElement {
                     idm:1;name: "Hôm Nay";title:"Chuyển nhanh đến ngày hôm nay"
                 }
                 ListElement {
                    idm:2; name: "Tới Ngày Âm Lịch";title:"Chọn ngày tháng năm Âm Lịch để chuyển tới"
                 }
                 ListElement {
                     idm:3;name: "Tới Ngày Dương Lịch";title:"Chọn ngày tháng năm Dương lịch để chuyến tới"
                 }
                 ListElement {
                     idm:4; name: "Xem Ngày Tốt/Xấu, Hoàng Đạo ...";title:"Giờ hòang đạo, sao tốt, sao xấu, nhị thập bát tú, ..."
                 }
                 ListElement {
                     idm:5; name: "Xem Theo Tháng";title:"Xem ngày Dương Lịch/Âm Lịch dưới dạng tháng"
                 }
               /*  ListElement {
                    idm:7; name: "Đổi Theme";title:"Thay đổi theme, hình nền, ..."
                 }
                 ListElement {
                    idm:8; name: "Đổi Hình Nền";title:"/opt/bar/load.jpg"
                 }*/
                 ListElement {
                     idm:6; name: "Giới Thiệu";title:"..."
                 }
         }

        ListView {
              id: listView
              anchors.fill: parent;anchors.topMargin: 45;anchors.leftMargin: 5;anchors.rightMargin: 5;anchors.bottomMargin: 55
              model: listModel
              delegate: listDelegate
              focus: true
        }

    }

    Rectangle {
        width : menuscreen.width
        height: 45
        color:"white"
        opacity: 0.5
    }

    Text {
        id: title

        anchors { horizontalCenter: menuscreen.horizontalCenter; top: menuscreen.top; topMargin: 10 }
        font.pixelSize: 22
        color: "black"
        text: qsTr("Menu")
        smooth: true
        font.bold: true
    }


    ToolBarSingle {
        id: toolBar; height: 42;
        y: parent.height-52
        width: parent.width;
        button1Label: "Quay Về"
        onButton1Clicked:menuscreen.close()
    }


    function getText(id) {
        /*switch(id){
        case 1:screen.reset();break;
        case 2: screen.state="amdatetimedialog";break;
        case 3: screen.state="datetimedialog";break;
        case 4: screen.state="xemngaytotxauhoangdao";break;
        case 5: screen.state="xemtheothang";break;
        case 6: menuscreen.close();screen.state="aboutdialog";break;
        case 7: screen.state="changetheme";break;
        case 8: screen.state="filebrowser";break;
        }*/
        menuscreen.close();
        menuscreen.item_click(id);
    }

    states: [
        State {
            name: "show"
            AnchorChanges { target: menuscreen; anchors.right: parent.right }
        },
        State {
            name: "close"
            AnchorChanges { target: menuscreen; anchors.right: parent.left }
        }
    ]

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 300 }
    }

}
