/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

import "Themes.js" as Themes
import "main.js" as Script

Item{
    id: fullmonth

    anchors.verticalCenter: parent.verticalCenter
    width: parent.width; height: parent.height;
    x:-(parent.width * 1.5)

    signal toolbar
    signal updatedate(int day, int month, int year)

    Loader {
        id: theme_manager
        property alias theme: theme_manager.item
        source: Themes.default_theme()
    }


    Component.onCompleted: {
        reset();
    }

    property int m_day: Script.curDay
    property int m_month: Script.curMonth
    property int m_year: Script.curYear

    property Component headerRenderer:Component {
        id: defaultHeaderRenderer

        Item {
            width: cellWidth
            height: cellHeight

            Rectangle {
                width: parent.width - 4
                height: parent.height - 4

                anchors.centerIn: parent

                radius: 4
                color: "#FAFAFF"
            }

            Text {
                width: cellWidth
                height: cellHeight

                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignHCenter

                text: model.modelData
                font.bold: true
                font.pointSize: parent.width > parent.height ? width ? width / 6 : 1 : width / 4
            }
        }
    }


    property Component daysRenderer:
    Component {
        Item {
            width: cellWidth
            height: cellHeight

            Rectangle {
                id:recms
                width: parent.width - 4
                height: parent.height - 4

                anchors.centerIn: parent

                radius: 4
                color: model ? model.inmonth ? (model.current ? "blue" : "lightsteelblue") : "#AAAAAA" : "black"
            }

            Text {
                id:txt_solar_day
                anchors.fill: parent
                anchors.leftMargin: parent.width > parent.height ? 10 : 5

                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignLeft

                text: model ? model.day : ""
                color: model ? model.inmonth ? (model.current ? "grey" : model.inholiday ? theme_manager.theme.markdate.holidays : "black") : "grey" : "red"
                font.pointSize: parent.width > parent.height ? parent.width ? parent.width / 6 : 1 : parent.width / 4
                font.bold: true
            }

            Text {
                anchors.fill: parent
                anchors.leftMargin: txt_solar_day.anchors.leftMargin+ parent.width > parent.height ? 60 : 35
                anchors.topMargin: 20

                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignBottom

                text: model ? model.lunar_day : ""
                color: model ? model.inmonth ? (model.current ? "white" : "#700070") : "grey" : "red"
                font.pointSize: parent.width > parent.height ? parent.width ? parent.width / 8 : 1 : parent.width / 5
            }

            MouseArea {
                id:memouse
                anchors.fill: parent

                property real mX
                property real mY
                property bool hold: false
                property bool clicked: false

                onClicked: {
                    if (model.inmonth){
                        fullmonth.updatedate(model.day, m_month, m_year)
                        hold=false;
                        m_day = model.day;
                        fullmonth.state="close";
                        fullmonth.toolbar();

                    }else{
                        if (model.isprevmonth){
                            m_month--;
                            if(m_month<=0){
                                m_month=12;
                                m_year--;
                            }
                        }else{
                            m_month++;
                            if (m_month >=13){
                                m_month=1;
                                m_year++;
                            }
                        }
                        fullmonth.reset();
                    }
                }

                onPositionChanged: {
                    mX = mouseX;
                    mY = mouseY;
                    hold=true;
                    clicked=false;
                }

                onPressed: {
                    recms.color="#F0F0F0"
                    clicked=true;
                }

                onReleased: {
                    recms.color=model ? model.inmonth ? (model.current ? "blue" : "lightsteelblue") : "#AAAAAA" : "black";
                    if (hold){
                        if (mouseY+mY<0){
                           if (Math.abs(mouseY) >= 100){
                              m_month++;
                               if (m_month >=13){
                                   m_month=1;
                                   m_year++;
                               }
                               reset();
                           }
                        }
                        else
                        {
                           if (mouseY >= 100){
                              m_month--;
                               if(m_month<=0){
                                   m_month=12;
                                   m_year--;
                               }
                               reset();
                           }
                        }
                        hold=false;
                    }
                }
            }
        }
    }

    Rectangle{
        id: fullmonthREC
        anchors.fill: parent; anchors.bottomMargin: 0
        opacity:0.9

        ListModel {
            id: monthModel
        }

        Grid {
            id: grid

            anchors.topMargin: 40
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.bottom: parent.bottom
            anchors.top: parent.top

            columns: 7
            rows: 7

            Repeater {
                model: ["CN", "Hai", "Ba", "Tư", "Năm", "Sáu", "Bảy"]

                delegate: Item {
                    id: headerDelegate

                    width: fullmonthREC.width / grid.columns
                    height: (fullmonthREC.height-92) / grid.rows

                    property int theIndex: index
                    property variant theModel: model

                    Loader {
                        property alias model: headerDelegate.theModel
                        property alias index: headerDelegate.theIndex
                        property alias cellWidth: headerDelegate.width
                        property alias cellHeight: headerDelegate.height

                        anchors.fill: parent

                        sourceComponent: headerRenderer
                    }
                }
            }

            Repeater {
                model: monthModel

                delegate: Item {
                    id: daysDelegate

                    property int theIndex: index
                    property variant theModel: model

                    width: fullmonthREC.width / grid.columns
                    height: (fullmonthREC.height-92) / grid.rows

                    Loader {
                        property alias model: daysDelegate.theModel
                        property alias index: daysDelegate.theIndex
                        property alias cellWidth: daysDelegate.width
                        property alias cellHeight: daysDelegate.height

                        anchors.fill: parent

                        sourceComponent: daysRenderer
                    }

                }
            }


        }

    }

    Rectangle {
        width : fullmonth.width
        height: 45
        color:"white"
        opacity: 0.5
    }

    Text {
        id: title

        anchors { horizontalCenter: fullmonth.horizontalCenter; top: fullmonth.top; topMargin: 10 }
        font.pixelSize: 22
        color: "black"
        text: "Tháng "+fullmonth.m_month+", "+fullmonth.m_year
        smooth: true
        font.bold: true
    }

    ToolBarSingle {
        id: toolBar; height: 42;
        y: parent.height-52
        width: parent.width;
        button1Label: "Quay Về"
        onButton1Clicked:{
            fullmonth.state="close";
            fullmonth.toolbar();
        }
    }

    function reset() {
        monthModel.clear()

        var firstdayofthemonthyear = Script.getLunarDate(1,m_month,m_year).jd;
        var startfrom = (firstdayofthemonthyear+1)%7;
        var daysofthemonthyear = Script.calDaysX(m_month,m_year);
        var j=1;
        var totalslot = 42;

        var nextmonth = get_nextmonth(totalslot - (startfrom+daysofthemonthyear))
        var prevmonth = get_prevmonth(startfrom)

        var dayclick, monthclick, yearclick;
        var datas1,datas,lunarclmonth,inmonth,isprevmonth;

        for (var i=0;i<42;i++){
            if (i >= startfrom && j<= daysofthemonthyear){
                dayclick = j;
                monthclick = m_month;
                yearclick = m_year;
                inmonth = true;
                isprevmonth=false;
                j++;
            }else{
                if (i<startfrom){
                    datas1=prevmonth[i];
                    isprevmonth = true;
                }
                else{
                    datas1=nextmonth[(totalslot-i)-1];
                    isprevmonth = false;
                }

                dayclick = datas1.duong;
                monthclick = datas1.month;
                yearclick = datas1.year;
                inmonth = false;
            }

            var current = false;
            if (dayclick == Script.curDay && monthclick==Script.curMonth && yearclick==Script.curYear)
                current = true

            var lunarcl = Script.getLunarDate(dayclick,monthclick,yearclick)
            var lunar_day = lunarcl.day;

            if (lunarcl.day === 1)
                lunar_day = lunarcl.day+"/"+lunarcl.month;

            var stemp = Script.convertSolar2Lunar(dayclick,monthclick,yearclick,7);
            var inholiday = Script.is_holiday(dayclick, monthclick, stemp[0], stemp[1]);

            monthModel.append({"day": dayclick, "current": current, "lunar_day":lunar_day, "inmonth":inmonth,"inholiday":inholiday,"isprevmonth":isprevmonth})
        }

    }

    function get_prevmonth(startfrom){
        var cMonth=m_month-1;
        var cYear=m_year;
        var pmonth = [];

        if (cMonth === 0){
            cMonth = 12;
            cYear--;
        }

         var daysofthemonthyear = Script.calDaysX(cMonth,cYear);
        for (var i=daysofthemonthyear;i>daysofthemonthyear-startfrom;i--){
            var lunarcl = Script.getLunarDate(i,cMonth,cYear)
            pmonth.push({duong:i, am:lunarcl.day, month:cMonth, year:cYear})
        }
        return pmonth.reverse()
    }

    function get_nextmonth(startfrom){
        var cMonth=m_month+1;
        var cYear=m_year;
         var pmonth = [];

        if (cMonth === 13){
            cMonth=1;
            cYear++;
        }

        for (var i=1;i<=startfrom;i++){
          var lunarcl = Script.getLunarDate(i,cMonth,cYear)
            pmonth.push({duong:i, am:lunarcl.day, month:cMonth, year:cYear});
        }
           return pmonth.reverse();
    }

    states: [
        State {
            name: "show"
            AnchorChanges { target: fullmonth; anchors.right: parent.right }
        },
        State {
            name: "close"
            AnchorChanges { target: fullmonth; anchors.right: parent.left }
        }
    ]

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 300 }
       }

}
