/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.1
import "Themes.js" as Themes

Item{
    id:change_theme

    Rectangle {
        id: rectangle1
        anchors.fill: parent; anchors.bottomMargin: 0
        visible: true
        opacity:0.9
        color:"white"

        Component {
                id: listDelegate
                Rectangle {
                    height:65
                MenuButton {
                     y: 3; width: parent.parent.width; height: 60
                    onClicked: {
                        listModel.select(index)
                    }
                    text: name
                    tip: title
                    selected:is_selected
                }
                }
            }

        ListModel {
                 id: listModel

                 Component.onCompleted: {
                     Themes.init(Controller, listModel);
                 }

                 ListElement {
                     idm:1;name: "DEFAULT";title:"Theme mặc định, không thể xóa";can_be_deleted:false;is_selected:true
                 }

                 function select(idx){
                     for(var i=0;i<listModel.count;i++)
                         setProperty(i, "is_selected",false)
                     setProperty(idx, "is_selected", true)
                 }
         }

        ListView {
              id: listView
              anchors.fill: parent;anchors.topMargin: 35;anchors.leftMargin: 5;anchors.rightMargin: 5;anchors.bottomMargin: 12
              model: listModel
              delegate: listDelegate
              focus: true
        }

    }

    ToolBar { id: toolBar; height: 50;
        y: screen.height-78
        width: parent.width;
        button1Label: "Đồng Ý"
        button2Label: "Hủy Bỏ"
        onButton1Clicked:
        {
            screen.state="mainscreen"
        }
        onButton2Clicked: {
            listModel.select(0)
            screen.state="mainscreen"
        }
    }

}
