#include "settings.h"
#include "ui_settings.h"

settings::settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::settings)
{
    ui->setupUi(this);
}

settings::~settings()
{
    delete ui;
}

void settings::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

bool settings::isCheckBoxChecked(int i)
{
    switch (i)
    {
    case 0:
        return ui->checkBoxMD5->isChecked();
        break;
    case 1:
        return ui->checkBoxSHA1->isChecked();
        break;
    case 2:
        return ui->checkBoxSHA224->isChecked();
        break;
    case 3:
        return ui->checkBoxSHA256->isChecked();
        break;
    case 4:
        return ui->checkBoxSHA384->isChecked();
        break;
    case 5:
        return ui->checkBoxSHA512->isChecked();
        break;
    case 6:
        return ui->checkBoxBase64->isChecked();
        break;
    default:
        return true;
    }
}

int settings::getSpinBoxValue()
{
    return ui->spinBoxBase64->value();
}

void settings::on_btnSelAll_clicked()
{
    ui->checkBoxMD5->setChecked(true);
    ui->checkBoxSHA1->setChecked(true);
    ui->checkBoxSHA224->setChecked(true);
    ui->checkBoxSHA256->setChecked(true);
    ui->checkBoxSHA384->setChecked(true);
    ui->checkBoxSHA512->setChecked(true);
    ui->checkBoxBase64->setChecked(true);
}

void settings::on_btnUnselAll_clicked()
{
    ui->checkBoxMD5->setChecked(false);
    ui->checkBoxSHA1->setChecked(false);
    ui->checkBoxSHA224->setChecked(false);
    ui->checkBoxSHA256->setChecked(false);
    ui->checkBoxSHA384->setChecked(false);
    ui->checkBoxSHA512->setChecked(false);
    ui->checkBoxBase64->setChecked(false);
}
