#include "output.h"
#include "ui_output.h"

output::output(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::output)
{
    ui->setupUi(this);
    uiSettings = new settings(this);
    uiVerify = new DialogVerify(this);

#ifdef Q_WS_MAEMO_5
        this->setAttribute(Qt::WA_Maemo5StackedWindow);
        this->setWindowFlags(Qt::Window);
#endif
}

output::~output()
{
    delete ui;
}

void output::setTextEditMD5(QString data)
{
    ui->textEditMD5->setText(data);
}

void output::setTextEditSHA1(QString data)
{
    ui->textEditSHA1->setText(data);
}

void output::setTextEditSHA224(QString data)
{
    ui->textEditSHA224->setText(data);
}

void output::setTextEditSHA256(QString data)
{
    ui->textEditSHA256->setText(data);
}

void output::setTextEditSHA384(QString data)
{
    ui->textEditSHA384->setText(data);
}

void output::setTextEditSHA512(QString data)
{
    ui->textEditSHA512->setText(data);
}

void output::setTextEditBase64(QString data)
{
    ui->textEditbase64->setText(data);
}

QString output::getTextEditMD5()
{
    return ui->textEditMD5->toPlainText();
}
QString output::getTextEditSHA1()
{
    return ui->textEditSHA1->toPlainText();
}
QString output::getTextEditSHA224()
{
    return ui->textEditSHA224->toPlainText();
}
QString output::getTextEditSHA256()
{
    return ui->textEditSHA256->toPlainText();
}
QString output::getTextEditSHA384()
{
    return ui->textEditSHA384->toPlainText();
}
QString output::getTextEditSHA512()
{
    return ui->textEditSHA512->toPlainText();
}
QString output::getTextEditBASE64()
{
    return ui->textEditbase64->toPlainText();
}

void output::on_pushButtonMD5_clicked()
{
    copyToClipboard(ui->textEditMD5->toPlainText());
}

void output::on_pushButtonSHA1_clicked()
{
    copyToClipboard(ui->textEditSHA1->toPlainText());
}

void output::on_pushButtonSHA256_clicked()
{
    copyToClipboard(ui->textEditSHA256->toPlainText());
}

void output::on_pushButtonSHA224_clicked()
{
    copyToClipboard(ui->textEditSHA224->toPlainText());
}

void output::on_pushButtonSHA384_clicked()
{
    copyToClipboard(ui->textEditSHA384->toPlainText());
}

void output::on_pushButtonSHA512_clicked()
{
    copyToClipboard(ui->textEditSHA512->toPlainText());
}

void output::on_pushButtonbase64_clicked()
{
    copyToClipboard(ui->textEditbase64->toPlainText());
}

void output::copyToClipboard(QString textToCopy)
{
    QClipboard *clipboard = QApplication::clipboard();
    clipboard->setText(textToCopy);
    ui->labelCopied->setText("String copied");
}

void output::on_tabOutput_currentChanged(int index)
{
    ui->labelCopied->clear();
}

void output::deleteTab(int i)
{
    switch (i)
    {
    case MD5:
        ui->tabMD5->setEnabled(false);
        ui->tabOutput->removeTab(ui->tabOutput->indexOf(ui->tabMD5));
        break;
    case SHA1:
        ui->tabSHA1->setEnabled(false);
        ui->tabOutput->removeTab(ui->tabOutput->indexOf(ui->tabSHA1));
        break;
    case SHA224:
        ui->tabSHA224->setEnabled(false);
        ui->tabOutput->removeTab(ui->tabOutput->indexOf(ui->tabSHA224));
        break;
    case SHA256:
        ui->tabSHA256->setEnabled(false);
        ui->tabOutput->removeTab(ui->tabOutput->indexOf(ui->tabSHA256));
        break;
    case SHA384:
        ui->tabSHA384->setEnabled(false);
        ui->tabOutput->removeTab(ui->tabOutput->indexOf(ui->tabSHA384));
        break;
    case SHA512:
        ui->tabSHA512->setEnabled(false);
        ui->tabOutput->removeTab(ui->tabOutput->indexOf(ui->tabSHA512));
        break;
    case BASE64:
        ui->tabBase64->setEnabled(false);
        ui->tabOutput->removeTab(ui->tabOutput->indexOf(ui->tabBase64));
        break;
    default:
        break;
    }
}

bool output::isTabDeleted(int i)
{
    switch (i)
    {
    case MD5:
        return !ui->tabMD5->isEnabled();
        break;
    case SHA1:
        return !ui->tabSHA1->isEnabled();
        break;
    case SHA224:
        return !ui->tabSHA224->isEnabled();
        break;
    case SHA256:
        return !ui->tabSHA256->isEnabled();
        break;
    case SHA384:
        return !ui->tabSHA384->isEnabled();
        break;
    case SHA512:
        return !ui->tabSHA512->isEnabled();
        break;
    case BASE64:
        return !ui->tabBase64->isEnabled();
        break;

    default:
        return true;
        break;
    }
}

void output::restoreTab(int i)
{
    switch (i)
    {
    case MD5:
        ui->tabMD5->setEnabled(true);
        ui->tabOutput->insertTab(MD5,ui->tabMD5, "MD5");
        break;
    case SHA1:
        ui->tabSHA1->setEnabled(true);
        ui->tabOutput->insertTab(SHA1,ui->tabSHA1, "SHA1");
        break;
    case SHA224:
        ui->tabSHA224->setEnabled(true);
        ui->tabOutput->insertTab(SHA224,ui->tabSHA224, "SHA224");
        break;
    case SHA256:
        ui->tabSHA256->setEnabled(true);
        ui->tabOutput->insertTab(SHA256,ui->tabSHA256, "SHA256");
        break;
    case SHA384:
        ui->tabSHA384->setEnabled(true);
        ui->tabOutput->insertTab(SHA384,ui->tabSHA384, "SHA384");
        break;
    case SHA512:
        ui->tabSHA512->setEnabled(true);
        ui->tabOutput->insertTab(SHA512,ui->tabSHA512, "SHA512");
        break;
    case BASE64:
        ui->tabBase64->setEnabled(true);
        ui->tabOutput->insertTab(BASE64,ui->tabBase64, "Base64");
        break;
    default:
        break;
    }
}

void output::on_actionVerify_triggered()
{
    uiVerify->show();
}
