#include "dialogverify.h"
#include "ui_dialogverify.h"

DialogVerify::DialogVerify(output* out, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DialogVerify)
{
    ui->setupUi(this);
    uiOutput = out;
}

DialogVerify::~DialogVerify()
{
    delete ui;
}

void DialogVerify::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void DialogVerify::on_btnVerify_clicked()
{
    QString textToCompare(ui->textEdit->toPlainText());
    if (uiOutput->getTextEditMD5() == textToCompare)
        ui->labelVerify->setText("Match found (MD5)");
    else
    if (uiOutput->getTextEditSHA1() == textToCompare)
        ui->labelVerify->setText("Match found (SHA1)");
    else
    if (uiOutput->getTextEditSHA224() == textToCompare)
        ui->labelVerify->setText("Match found (SHA224)");
    else
    if (uiOutput->getTextEditSHA256() == textToCompare)
        ui->labelVerify->setText("Match found (SHA256)");
    else
    if (uiOutput->getTextEditSHA384() == textToCompare)
        ui->labelVerify->setText("Match found (SHA384)");
    else
    if (uiOutput->getTextEditSHA512() == textToCompare)
        ui->labelVerify->setText("Match found (SHA512)");
    else
    if (uiOutput->getTextEditBASE64() == textToCompare)
        ui->labelVerify->setText("Match found (Base64)");
    else
        ui->labelVerify->setText("No matches found");
}

void DialogVerify::on_btnPaste_clicked()
{
    QClipboard* clipboard = QApplication::clipboard();
    QString textToPaste = clipboard->text();
    ui->textEdit->setText(textToPaste);
}

void DialogVerify::on_btnClearVerify_clicked()
{
    ui->textEdit->clear();
    ui->labelVerify->clear();
}
