#include "calculations.h"
#include "mainhashes.h"

calculations::calculations(QObject *parent) :
    QObject(parent)
{
    ifaceMain = dynamic_cast<MainHashes*>(parent);
}

QString calculations::HashTextMD5(QString text)
{
    QString str(text);
    QByteArray hash = QCryptographicHash::hash(str.toUtf8(), QCryptographicHash::Md5);
    QString datareturn(hash.toHex());
    return datareturn.toUtf8();
}

QString calculations::HashTextSHA1(QString text)
{
    QString str(text);
    QByteArray hash = QCryptographicHash::hash(str.toUtf8(), QCryptographicHash::Sha1);
    QString datareturn(hash.toHex());
    return datareturn.toUtf8();
}


QString calculations::HashTextSHA224(QString text)
{
    QCA::init();

    if (QCA::isSupported("sha224"))
    {
        QCA::SecureArray arg = text.toLatin1();
        QString result = QCA::Hash("sha224").hashToString(arg);
        return result.toUtf8();
    } else {
        QString error = "Error: sha224 not supported!";
        return error;
    }
}

QString calculations::HashTextSHA256(QString text)
{
    QCA::init();

    if (QCA::isSupported("sha256"))
    {
        QCA::SecureArray arg = text.toLatin1();
        QString result = QCA::Hash("sha256").hashToString(arg);
        return result.toUtf8();
    } else {
        QString error = "Error: sha256 not supported!";
        return error;
    }
}

QString calculations::HashTextSHA384(QString text)
{
    QCA::init();

    if (QCA::isSupported("sha384"))
    {
        QCA::SecureArray arg = text.toLatin1();
        QString result = QCA::Hash("sha384").hashToString(arg);
        return result.toUtf8();
    } else {
        QString error = "Error: sha384 not supported!";
        return error;
    }
}

QString calculations::HashTextSHA512(QString text)
{
    QCA::init();

    if (QCA::isSupported("sha512"))
    {
        QCA::SecureArray arg = text.toLatin1();
        QString result = QCA::Hash("sha512").hashToString(arg);
        return result.toUtf8();
    } else {
        QString error = "Error: sha512 not supported!";
        return error;
    }
}

QString calculations::HashTextBase64(QString text)
{
    QByteArray hash = text.toUtf8();
    QString datareturn(hash.toBase64());
    return datareturn.toUtf8();
}

void calculations::HashFileMD5()
{
    QFile file(filename);
    stop = false;

    QCryptographicHash md5sum(QCryptographicHash::Md5);
    if (file.open(QIODevice::ReadOnly))
    {
        qint64 maxRead = 8192;
        qint64 bytesReaded = 0;
        qint64 totalReaded = 0;
        qint64 sizeOfFile = file.size();
        bool jobcanceled = false;
        char dataReaded[maxRead];
        qDebug() << "Computing hash MD5";
        emit updateLabel("MD5");
        while (!stop)
        {
            while (!file.atEnd())
            {
                if (stop)
                {
                    qDebug() << "stopped";
                    jobcanceled=true;
                    //emit canceled();
                    break;
                }
                bytesReaded = file.read(dataReaded, maxRead);
                md5sum.addData(dataReaded, bytesReaded);
                totalReaded +=bytesReaded;
                emit updateProgressBar(totalReaded, sizeOfFile);
            }

            file.close();
            if (!jobcanceled)
            {
                QByteArray datareturn(md5sum.result().toHex());
                emit hashDone(QString(datareturn).toUtf8(), MD5);
                qDebug() << "emited md5: " << datareturn;
            } else {
                emit hashDone(QString("Canceled by user"), MD5);
            }
            stop = true;
        }
    }
    else
        emit hashDone(QString("Error openning "+filename), MD5);
    qDebug() << "md5 emit finished";
    emit finished();
}

void calculations::HashFileSHA1()
{
    QFile file(filename);
    stop = false;
    QCryptographicHash sha1sum(QCryptographicHash::Sha1);
    if (file.open(QIODevice::ReadOnly))
    {
        qint64 maxRead = 8192;
        qint64 bytesReaded = 0;
        qint64 totalReaded = 0;
        qint64 sizeOfFile = file.size();
        bool jobcanceled = false;
        char dataReaded[maxRead];
        qDebug() << "Computing hash SHA1";
        emit updateLabel("Sha1");
        while (!stop)
        {
            while (!file.atEnd())
            {
                if (stop)
                {
                    qDebug() << "stopped";
                    jobcanceled=true;
                    //emit canceled();
                    break;
                }
                bytesReaded = file.read(dataReaded, maxRead);
                sha1sum.addData(dataReaded, bytesReaded);
                totalReaded +=bytesReaded;
                emit updateProgressBar(totalReaded, sizeOfFile);
            }
            file.close();
            if (!jobcanceled)
            {
                QByteArray datareturn = QString(sha1sum.result().toHex()).toUtf8();

                emit hashDone(datareturn, SHA1);
                qDebug() << "emited sha1: " << datareturn;
            }
            else {
                emit hashDone(QString("Canceled by user"), SHA1);
            }
            stop=true;
        }
     }
    else
        emit hashDone(QString("Error openning "+filename), SHA1);
    qDebug() << "sha1 emit finished";
    emit finished();
}

void calculations::HashFileSHA224()
{
    QCA::init();
    stop = false;
    QFile file(filename);

    if (file.open(QIODevice::ReadOnly))
    {
        qint64 maxRead = 8192;
        qint64 bytesReaded = 0;
        qint64 totalReaded = 0;
        qint64 sizeOfFile = file.size();
        bool jobcanceled = false;
        char dataReaded[maxRead];

        if (QCA::isSupported("sha224"))
        {
            qDebug() << "Computing SHA224";
            emit updateLabel("Sha224");
            QCA::Hash sha224("sha224");
            while (!stop)
            {
                while (!file.atEnd())
                {
                    if (stop)
                    {
                        qDebug() << "stopped";
                        jobcanceled=true;
                        //emit canceled();
                        break;
                    }
                    bytesReaded = file.read(dataReaded, maxRead);
                    sha224.update(dataReaded, bytesReaded);
                    totalReaded +=bytesReaded;
                    emit updateProgressBar(totalReaded, sizeOfFile);
                }
                file.close();
                if (!jobcanceled)
                {
                    QString result = QString(sha224.final().toByteArray().toHex()).toUtf8();

                    emit hashDone(result, SHA224);
                    qDebug() << "emited sha224: " << result;
                } else {
                    emit hashDone(QString("Canceled by user"), SHA224);
                }
                stop=true;
            }
        }
        else {
            file.close();
            emit hashDone(QString("Sha224 not supported"), SHA224);
        }
    }
    else
        emit hashDone(QString("Error openning "+filename), SHA224);
    qDebug() << "sha224 emit finished";
    emit finished();
}

void calculations::HashFileSHA256()
{
    QCA::init();
    stop = false;
    QFile file(filename);

    if (file.open(QIODevice::ReadOnly))
    {
        qint64 maxRead = 8192;
        qint64 bytesReaded = 0;
        qint64 totalReaded = 0;
        qint64 sizeOfFile = file.size();
        bool jobcanceled = false;
        char dataReaded[maxRead];

        if (QCA::isSupported("sha256"))
        {
            QCA::Hash sha256("sha256");
            qDebug() << "Computing SHA256";
            emit updateLabel("Sha256");
            while (!stop)
            {
                while (!file.atEnd())
                {
                    if (stop)
                    {
                        qDebug() << "stopped";
                        jobcanceled=true;
                        //emit canceled();
                        break;
                    }
                    bytesReaded = file.read(dataReaded, maxRead);
                    sha256.update(dataReaded, bytesReaded);
                    totalReaded +=bytesReaded;
                    emit updateProgressBar(totalReaded, sizeOfFile);
                }
                file.close();
                if (!jobcanceled)
                {
                    QString result = QString(sha256.final().toByteArray().toHex()).toUtf8();

                    emit hashDone(result, SHA256);
                    qDebug() << "emited sha256: " << result;
                } else {
                    emit hashDone(QString("Canceled by user"), SHA256);
                }
                stop=true;
            }
        }
        else {
            file.close();
            emit hashDone(QString("Sha256 not supported"), SHA256);
        }
    }
    else
        emit hashDone(QString("Error openning "+filename), SHA256);
    qDebug() << "sha256 emit finished";
    emit finished();
}

void calculations::HashFileSHA384()
{
    QCA::init();
    stop = false;
    QFile file(filename);

    if (file.open(QIODevice::ReadOnly))
    {
        qint64 maxRead = 8192;
        qint64 bytesReaded = 0;
        qint64 totalReaded = 0;
        qint64 sizeOfFile = file.size();
        bool jobcanceled = false;
        char dataReaded[maxRead];

        if (QCA::isSupported("sha384"))
        {
            QCA::Hash sha384("sha384");
            qDebug() << "Computing SHA384";
            emit updateLabel("Sha384");
            while (!stop)
            {
                while (!file.atEnd())
                {
                    if (stop)
                    {
                        qDebug() << "stopped";
                        jobcanceled=true;
                        //emit canceled();
                        break;
                    }
                    bytesReaded = file.read(dataReaded, maxRead);
                    sha384.update(dataReaded, bytesReaded);
                    totalReaded +=bytesReaded;
                    emit updateProgressBar(totalReaded, sizeOfFile);
                }
                file.close();
                if (!jobcanceled)
                {
                    QString result = QString(sha384.final().toByteArray().toHex()).toUtf8();

                    emit hashDone(result, SHA384);
                    qDebug() << "emited sha384: " << result;
                } else {
                    emit hashDone(QString("Canceled by user"), SHA384);
                }
                stop=true;
            }
        }
        else {
            file.close();
            emit hashDone(QString("Sha384 not supported"), SHA384);
        }
    }
    else
        emit hashDone(QString("Error openning "+filename), SHA384);
    qDebug() << "sha384 emit finished";
    emit finished();
}

void calculations::HashFileSHA512()
{
    QCA::init();
    stop = false;
    QFile file(filename);

    if (file.open(QIODevice::ReadOnly))
    {
        qint64 maxRead = 8192;
        qint64 bytesReaded = 0;
        qint64 totalReaded = 0;
        qint64 sizeOfFile = file.size();
        bool jobcanceled = false;
        char dataReaded[maxRead];

        if (QCA::isSupported("sha512"))
        {
            QCA::Hash sha512("sha512");
            qDebug() << "Computing SHA512";
            emit updateLabel("Sha512");
            while (!stop)
            {
                while (!file.atEnd())
                {
                    if (stop)
                    {
                        qDebug() << "stopped";
                        jobcanceled=true;
                        //emit canceled();
                        break;
                    }
                    bytesReaded = file.read(dataReaded, maxRead);
                    sha512.update(dataReaded, bytesReaded);
                    totalReaded +=bytesReaded;
                    emit updateProgressBar(totalReaded, sizeOfFile);
                }
                file.close();
                if (!jobcanceled)
                {
                    QString result = QString(sha512.final().toByteArray().toHex()).toUtf8();

                    emit hashDone(result, SHA512);
                    qDebug() << "emited sha512: " << result;
                } else {
                    emit hashDone(QString("Canceled by user"), SHA512);
                }
                stop=true;
            }
        }
        else {
            file.close();
            emit hashDone(QString("Sha512 not supported"), SHA512);
        }
    }
    else
        emit hashDone(QString("Error openning "+filename), SHA512);
    qDebug() << "sha512 emit finished";
    emit finished();
}

void calculations::HashFileBase64()
{
    QFile file(filename);
    stop = false;

    if (file.open(QIODevice::ReadOnly))
    {
        qint64 maxRead = 8192;
        qint64 bytesReaded = 0;
        qint64 totalReaded = 0;
        qint64 sizeOfFile = file.size();
        QByteArray data;
        bool jobcanceled = false;
        char dataReaded[maxRead];
        qDebug() << "Computing base64";
        emit updateLabel("Base64");
        while (!stop)
        {
            while (!file.atEnd())
            {
                if (stop)
                {
                    qDebug() << "stopped";
                    jobcanceled=true;
                    //emit canceled();
                    break;
                }
                bytesReaded = file.read(dataReaded, maxRead);
                data.append(dataReaded, bytesReaded);
                totalReaded +=bytesReaded;
                emit updateProgressBar(totalReaded, sizeOfFile);
            }
            file.close();
            if (!jobcanceled)
            {
                QString result = QString(data.toBase64());

                emit hashDone(result.toUtf8(), BASE64);
                qDebug() << "emited base64";
            }
            else {
                emit hashDone(QString("Canceled by user"), BASE64);
            }
            stop=true;
        }
    }
    else
        emit hashDone(QString("Error openning "+filename), BASE64);
    qDebug() << "Base64 emit finished";
    emit finished();
}

int calculations::randomBetween(int min, int max)
{
    return qrand() % ((max + 1) - min) + min;
}

void calculations::setJob(QThread &thread, int numJob, QString name)
{
    switch(numJob)
    {
    case MD5:
        connect(&thread, SIGNAL(started()), this, SLOT(HashFileMD5()));
        break;
    case SHA1:
        connect(&thread, SIGNAL(started()), this, SLOT(HashFileSHA1()));
        break;
    case SHA224:
        connect(&thread, SIGNAL(started()), this, SLOT(HashFileSHA224()));
        break;
    case SHA256:
        connect(&thread, SIGNAL(started()), this, SLOT(HashFileSHA256()));
        break;
    case SHA384:
        connect(&thread, SIGNAL(started()), this, SLOT(HashFileSHA384()));
        break;
    case SHA512:
        connect(&thread, SIGNAL(started()), this, SLOT(HashFileSHA512()));
        break;
    case BASE64:
        connect(&thread, SIGNAL(started()), this, SLOT(HashFileBase64()));
        break;
    default:
        break;
    }
    this->filename = name;
}

void calculations::canceljob()
{
    qDebug() << "canceling job";
    this->stop = true;
}

