#!/usr/bin/env python2.5

# 
# Copyright (c) 2007-2008 INdT.
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# ============================================================================
# Name        : levelball.py
# Author      : Gianfranco D'Alessandro
# Version     : 0.1
# Description : A simple Descktop Level using accelerometer 
# ============================================================================

import gtk
import hildon
import hildondesktop
import gobject
import pygtk; pygtk.require("2.0")

def read_style():
    f = open('/data/level.conf', 'r')
    style = f.readline()
    f.close()
    return style

def set_style():
    style = read_style()
    if style == '1':
        pixbuf = gtk.gdk.pixbuf_new_from_file ('/img/LockSliderThumb24.png')
    elif style == '2':
        pixbuf = gtk.gdk.pixbuf_new_from_file ('/img/gtk-yes24.png')
    elif style == '3':
        pixbuf = gtk.gdk.pixbuf_new_from_file ('/img/gtk-no24.png')
    return pixbuf

class GDDialog(gtk.Dialog):
    def __init__(self):
        gtk.Dialog.__init__(self, "Setting", None,
                            gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR,
                            ("Set", gtk.RESPONSE_OK))        
        
        self.imageS = gtk.image_new_from_stock(gtk.STOCK_SAVE, gtk.ICON_SIZE_BUTTON)
        
        style = read_style()       
        
        lock = gtk.image_new_from_file('/img/LockSliderThumb24.png')
        green = gtk.image_new_from_file('/img/gtk-yes24.png')
        red = gtk.image_new_from_file('/img/gtk-no24.png')
       
        button5 = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, None)
        button5.set_label("Lock Slider Style")
        button5.set_image(lock)
        button5.connect("clicked", self.button_clicked)
        button5.set_mode(True)
        if style == '1':
            button5.set_active(True)
        else:
            button5.set_active(False)
   
        button6 = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, button5)
        button6.set_label("Green Style")
        button6.set_image(green)
        button6.connect("clicked", self.button_clicked)
        button6.set_mode(True)
        if style == '2':
            button6.set_active(True)
        else:
            button6.set_active(False)
        
        button7 = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, button5)
        button7.set_label("Red Style")
        button7.set_image(red)
        button7.connect("clicked", self.button_clicked)
        button7.set_mode(True)
        if style == '3':
            button7.set_active(True)
        else:
            button7.set_active(False)
 
        self.vbox.add(gtk.Label("Select Ball Style"))
        
        self.vbox.pack_start(button5)
        self.vbox.pack_start(button6)
        self.vbox.pack_start(button7)
        self.show_all()

    def button_clicked(self, button):
        buttontext = button.get_label()
        if buttontext == "Lock Slider Style":
            style=1
        elif buttontext == "Green Style":
            style=2
        elif buttontext == "Red Style":
            style=3
                
        f = open('/data/level.conf', 'w')
        f.write(str(style))
        f.close

def GD_dialog_show(button3):
    dialog = GDDialog()
    dialog.run()
    dialog.destroy()
    

class ACCplugin(hildondesktop.HomePluginItem):
    def __init__(self):
        hildondesktop.HomePluginItem.__init__(self)

               
        self.pos = 118
        self.x = 54
        self.x_old = 0
        self.hbox = gtk.HBox()

        self.pixbuf = set_style()
        
        self.pixbufM = gtk.gdk.pixbuf_new_from_file ('/img/Base3.png')
     
     
        self.imageP = gtk.image_new_from_file('AppletConfigureButton.png')
        self.area = gtk.DrawingArea()
        self.area.set_size_request(300, 54)
#        self.drawable = self.area.window
        
        self.style1 = self.area.get_style()
        self.gc = self.style1.fg_gc[gtk.STATE_NORMAL]
        self.area.connect("expose-event", self.expose)
         
        self.button = gtk.Button(label="Start")
        self.button.connect("clicked", self.start)
        self.button2 = gtk.Button(label="Stop")
        self.button2.connect("clicked", self.stop)
        self.button3 = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
 #       self.button3.set_size_request(50,50)
        self.button3.set_label("")
        self.button3.set_image(self.imageP)
        self.button3.set_image_position(gtk.POS_LEFT)
        self.button3.connect("clicked", GD_dialog_show)   
        
        self.hbox.pack_start(self.area)
        self.hbox.pack_start(self.button)
        self.hbox.pack_start(self.button2)
        self.hbox.pack_start(self.button3)

        self.hbox.show_all()
        self.add(self.hbox) 
        
        self.running = False
        self.button.set_sensitive(True)
        self.button2.set_sensitive(False)
        self.button3.set_sensitive(True)
        self.update()
 
    def expose(self, windget, event):
        self.area.window.draw_pixbuf(self.gc, self.pixbufM, 0, 0, 0, 4)
        self.area.window.draw_pixbuf(self.gc, self.pixbuf, 0, 0, self.pos + self.x/12, 6)
    
    def update(self):
        if self.running == True:
            
            self.x, y, z = self.get_rotation()
            
            appo_x = self.x
            self.x = (self.x_old+self.x) / 12
            int(self.x)
            self.x_old = appo_x
 
            src_x = 0 
            src_y = 0
            dest_x = self.pos + self.x

            dest_y = 0
            if dest_x >= 253:
                dest_x = 253
            if dest_x <= 0:
                dest_x = 0

            self.area.window.draw_pixbuf(self.gc, self.pixbufM, 0, 0, 0, 4)
            self.area.window.draw_pixbuf(self.gc, self.pixbuf, 0, 0, dest_x, 6)

            gobject.timeout_add(25, self.update)
            
            
    def start(self, user_data=None):
        self.pixbuf = set_style()
        if self.running == False:
            self.running = True
            self.button.set_sensitive(False)
            self.button2.set_sensitive(True)
            self.button3.set_sensitive(False)
            self.update()
        self.update()

    def stop(self, user_data=None):
        if self.running == True:
            self.running = False
            self.button.set_sensitive(True)
            self.button2.set_sensitive(False)
            self.button3.set_sensitive(True)            
            
    def get_rotation(self):
        f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
        coords = [int(w) for w in f.readline().split()]
        f.close()
        return coords

def run():
    obj.show_all()
    gtk.main()

global obj 

if __name__ == "__main__":
    hd_plugin_type = ACCplugin
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    run()