#! /usr/bin/env python
import pygtk
from svg import SVG
from languages import Lang
pygtk.require('2.0')
import gtk, gobject, cairo
import random
import math

NORMAL = 0
PRACTICE = 1

#region = "europe"
#doc = SVG("../res/" + region + ".svg")
#country_codes = doc.get_country_codes()
#l = Lang()
#countries = l.country_names(region, country_codes, "Swedish")
#print countries


class Game(gtk.DrawingArea):

    def destroy(self, widget, data=None):
        gtk.main_quit()
    
    def __init__(self, region, language, mode):
        super(Game, self).__init__()

        print NORMAL
        ## Old fashioned way to connect expose. I don't savvy the gobject stuff.
        self.mode = mode
        self.connect ( "expose_event", self.do_expose_event )
        self.connect("delete-event", gtk.main_quit)
        #self.connect("button-press-event", self.mus)
        #self.connect("key-press-event", self.key)

        try:
            self.doc = SVG("res/" + region + ".svg")
        except:
            self.doc = SVG("/opt/leif/src/res/" + region + ".svg")

        self.country_codes = self.doc.get_country_codes()

        l = Lang()
        self.countries = l.country_names(region, self.country_codes, language)

        self.offset_x = 0
        self.zoom = 1.0
        self.x = 0
        self.y = 0
        self.offset_x = 0
        self.offset_y = 0

        #just mark a random country
        self.currcountry = self.country_codes[random.randint(0,
                                     len(self.country_codes)-1)]

        self.country = self.country_codes[random.randint(0,
                                     len(self.country_codes)-1)]

        #self.lastcountry = self.country_codes[random.randint(0,
         #                            len(self.country_codes)-1)]
        self.lastcountry = None

        self.right_answer = False
    
        gobject.timeout_add( 10, self.tick )


    def tick(self):
        ## This invalidates the screen, causing the expose event to fire.
        self.alloc = self.get_allocation ( )
        rect = gtk.gdk.Rectangle ( self.alloc.x, self.alloc.y, self.alloc.width, self.alloc.height )
        self.window.invalidate_rect ( rect, True )        
        return True # Causes timeout to tick again.


    # Handle the expose-event by drawing
    def do_expose_event(self, widget, event):
        cr = self.window.cairo_create()
        # Restrict Cairo to the exposed area; avoid extra work
        cr.rectangle(event.area.x, event.area.y,
                event.area.width, event.area.height)
        cr.clip()
        
        self.draw(cr, *self.window.get_size())

    def draw(self, cr, width, height):
        cr.set_source_rgb(1, 1, 1)
        for c in self.country_codes:
            if c == self.currcountry:
                cr.set_source_rgb(1,0,1)

            self.doc.render(cr, c, (self.offset_x, self.offset_y), self.zoom)

            #if self.doc.collides(cr, (self.x, self.y)):
            if self.doc.collides(cr, 
                                 (self.x*self.zoom-self.offset_x, 
                                  self.y*self.zoom-self.offset_y)):
                self.currcountry = c
                #print self.currcountry, self.country, self.lastcountry, c
                
                if c == self.lastcountry:
                    self.right_answer = True
                else:
                    self.right_answer = False
            cr.fill()
            cr.set_source_rgb(1,1,1)


        cr.set_source_rgba(0, 0, 0, .8)
        cr.rectangle(0, 350, 800, 130)
        cr.fill()
        cr.move_to(30, 385)
        cr.set_font_size(30)

        cr.set_source_rgba(1,1,1)

        if self.mode == NORMAL:
            #print out the country you should mark
            cr.show_text(self.countries[self.country])
        elif self.mode == PRACTICE:
            #print out the marked country
            cr.show_text(self.countries[self.currcountry])
            
        if self.mode == NORMAL:
            if self.right_answer:
                cr.move_to(670, 385)
                cr.show_text("Right!")
            else:
                cr.move_to(670,385)
                cr.show_text("FAIL!")
        #cr.set_source_rgba(0,0,0,.7)
        cr.fill()

    def mus(self, widget, event):
        self.x = event.x/self.zoom+self.offset_x/self.zoom
        self.y = event.y/self.zoom+self.offset_y/self.zoom

        self.lastcountry = self.country
        self.country = self.country_codes[random.randint(0,len(self.country_codes)-1)]

    def key(self, widget, event):
        if event.keyval == gtk.keysyms.Left:
            self.offset_x -= 30
        elif event.keyval == gtk.keysyms.Right:
            self.offset_x += 30
        elif event.keyval == gtk.keysyms.Down:
            self.offset_y += 30
        elif event.keyval == gtk.keysyms.Up:
            self.offset_y -= 30
    
            #zoom!
        if event.keyval == 43: #plus!
            self.zoom += 1.0
            #fix a better zoom offset thingy..
            #scr.offset_x *= scr.zoom
            #scr.offset_y *= scr.zoom
        elif event.keyval == 45: #minus!
            self.zoom -= 1.0

# GTK mumbo-jumbo to show the widget in a window and quit when it's closed
"""
def run(Widget):
    window = gtk.Window()
    widget = Widget("europe", "Swedish")
    #print dir(gtk)
    #gtk.Widget.add_events(window, 256)
    widget.add_events(256)
    window.connect("delete-event", gtk.main_quit)
    window.connect("button-press-event", widget.mus)
    window.connect("key-press-event", widget.key)

    widget.show()
    window.add(widget)
    window.present()
    gtk.main()
"""
#run(scr)

#if __name__ == "__main__":
#    run(Screen)
