#! /bin/sh

oldrev=$1
newrev=$2

set -e
set -x

CHLOG=changelog.new
cd ..

if [ -z "$newrev" ]
then
	newrev=`git describe`
fi

if [ -z "$oldrev" ]
then
	oldrev=cat changelog | sed 's/.*(//' | sed 's/).*//' | sed -r 's/-[0-9]{1,}$//' | sed 's/~/-'
fi

echo "leechcraft (`git describe $newrev|sed 's/-/~/g'|sed s/$/-1/`) unstable; urgency=low" > debian/$CHLOG
echo >> debian/$CHLOG
git log --pretty=format:'  %s' $oldrev..$newrev | sed -r "s/\. \+/\.\n  \+/" | sed -r "s/\. \*/\.\n  \*/" | sed -r "s/\> \*/\n  \*/" | sed -r "s/\. \-/\.\n  \-/" | sed -r "s/(.{1,72})(.+)/\1/" | grep "[:alphanum:]\+" >> debian/$CHLOG
cd debian
echo >> $CHLOG
echo -n " -- Daniel Guzanoff <melkor217@gmail.com>  " >> $CHLOG
date -R >> $CHLOG
echo >> $CHLOG
cat changelog >> $CHLOG

mv -f $CHLOG changelog
