#include "ledpulse-led-files.h"
#include <stdlib.h>
#include <gtk/gtk.h>

static void ledpulse_led_files_write_to_led(FILE* file, int data)
{
  if(file)
  {
    rewind(file);
    fprintf(file, "%d\n", data);
  }
}

LedFileDescriptors* ledpulse_led_files_create() {
  LedFileDescriptors* d = (LedFileDescriptors*)g_malloc0(sizeof(LedFileDescriptors));
  return d;
}

void ledpulse_led_files_write_to_leds(LedFileDescriptors* led_files, LedPulseSettings* settings, int data)
{
  if(!led_files)
    return;
  if(settings->red_led)
    ledpulse_led_files_write_to_led(led_files->red_led_file, data);
  if(settings->green_led)
    ledpulse_led_files_write_to_led(led_files->green_led_file, data);
  if(settings->blue_led)
    ledpulse_led_files_write_to_led(led_files->blue_led_file, data);
  if(settings->kb1_led)
    ledpulse_led_files_write_to_led(led_files->kb1_led_file, data);
  if(settings->kb2_led)
    ledpulse_led_files_write_to_led(led_files->kb2_led_file, data);
  if(settings->kb3_led)
    ledpulse_led_files_write_to_led(led_files->kb3_led_file, data);
  if(settings->kb4_led)
    ledpulse_led_files_write_to_led(led_files->kb4_led_file, data);
  if(settings->kb5_led)
    ledpulse_led_files_write_to_led(led_files->kb5_led_file, data);
  if(settings->kb6_led)
    ledpulse_led_files_write_to_led(led_files->kb6_led_file, data);
}

void ledpulse_led_files_close_leds(LedFileDescriptors* led_files)
{
  if(led_files->green_led_file) {
    fclose(led_files->green_led_file);
    led_files->green_led_file = NULL;
  }
  if(led_files->red_led_file) {
    fclose(led_files->red_led_file);
    led_files->red_led_file = NULL;
  }
  if(led_files->blue_led_file) {

    fclose(led_files->blue_led_file);
    led_files->blue_led_file = NULL;
  }
  if(led_files->kb1_led_file) {
    fclose(led_files->kb1_led_file);
    led_files->kb1_led_file = NULL;
  }
  if(led_files->kb2_led_file) {
    fclose(led_files->kb2_led_file);
    led_files->kb2_led_file = NULL;
  }
  if(led_files->kb3_led_file) {
    fclose(led_files->kb3_led_file);
    led_files->kb3_led_file = NULL;
  }
  if(led_files->kb4_led_file) {
    fclose(led_files->kb4_led_file);
    led_files->kb4_led_file = NULL;
  }
  if(led_files->kb5_led_file) {
    fclose(led_files->kb5_led_file);
    led_files->kb5_led_file = NULL;
  }
  if(led_files->kb6_led_file) {
    fclose(led_files->kb6_led_file);
    led_files->kb6_led_file = NULL;
  }
}

void ledpulse_led_files_open_from(LedFileDescriptors* led_files, LedPulseSettings* settings)
{
  if(settings->red_led)
    led_files->red_led_file = fopen(RED_LED_FILE, "w+");
  if(settings->green_led)
    led_files->green_led_file = fopen(GREEN_LED_FILE, "w+");
  if(settings->blue_led)
    led_files->blue_led_file = fopen(BLUE_LED_FILE, "w+");
  if(settings->kb1_led)
    led_files->kb1_led_file = fopen(KB1_LED_FILE, "w+");
  if(settings->kb2_led)
    led_files->kb2_led_file = fopen(KB2_LED_FILE, "w+");
  if(settings->kb3_led)
    led_files->kb3_led_file = fopen(KB3_LED_FILE, "w+");
  if(settings->kb4_led)
    led_files->kb4_led_file = fopen(KB4_LED_FILE, "w+");
  if(settings->kb5_led)
    led_files->kb5_led_file = fopen(KB5_LED_FILE, "w+");
  if(settings->kb6_led)
    led_files->kb6_led_file = fopen(KB6_LED_FILE, "w+");
}
