/*
 *  ledpulse for the maemo desktop.
 *  Copyright (C) 2013 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "ledpulse-home-plugin.h"
#include "ledpulse-settings.h"
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <gconf/gconf-client.h>
#include <stdlib.h>

#define GCONF_PATH "/apps/maemo/ledpulse"
#define GCONF_PATH_RED_LED GCONF_PATH "/red_led"
#define GCONF_PATH_BLUE_LED GCONF_PATH "/blue_led"
#define GCONF_PATH_GREEN_LED GCONF_PATH "/green_led"
#define GCONF_PATH_KB1_LED GCONF_PATH "/keyboard1_led"
#define GCONF_PATH_KB2_LED GCONF_PATH "/keyboard2_led"
#define GCONF_PATH_KB3_LED GCONF_PATH "/keyboard3_led"
#define GCONF_PATH_KB4_LED GCONF_PATH "/keyboard4_led"
#define GCONF_PATH_KB5_LED GCONF_PATH "/keyboard5_led"
#define GCONF_PATH_KB6_LED GCONF_PATH "/keyboard6_led"

typedef struct {
  GtkWidget* dialog;
  LedPulseSettings* settings;
  LedPulseHomePlugin* plugin;
} LedPulseSettingsDialog;


static 
void ledpulse_settings_dialog_response(GtkDialog* dialog, gint response_id, gpointer userdata)
{
  LedPulseSettingsDialog* settings_dialog = (LedPulseSettingsDialog*)userdata;
  if(response_id = GTK_RESPONSE_OK)
  {
    ledpulse_settings_save(settings_dialog->settings);
    ledpulse_home_plugin_reload_settings(settings_dialog->plugin);
  }
  gtk_widget_destroy(settings_dialog->dialog);
  g_free(settings_dialog->settings);
  g_free(settings_dialog);
}

static void checkBoxToggled(HildonCheckButton* button, gpointer userdata) {
  gboolean* setting = (gboolean*)userdata;
  (*setting) = hildon_check_button_get_active(button);
}

static void set_source_callback(HildonTouchSelector* selector,
				gint column,
				gpointer userdata)
{
  LedPulseSettings* settings = (LedPulseSettings*)userdata;
  if(settings->source)
    g_free(settings->source);
  settings->source = hildon_touch_selector_get_current_text(selector);
}

static void create_source_selection_box(GtkWidget* area, LedPulseSettings* settings)
{
  GtkWidget* selector = hildon_touch_selector_new_text();
  int index = 0;
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(selector),
				    "Monitor");
  if(g_strcmp0("Monitor", settings->source)==0)
    hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR(selector),0,index);
  index++;
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(selector),
				    "Bluetooth");
  if(g_strcmp0("Bluetooth", settings->source)==0)
    hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR(selector),0,index);
  index++;
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(selector),
				    "Microphone");
  if(g_strcmp0("Microphone", settings->source)==0)
    hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR(selector),0,index);

  g_signal_connect(G_OBJECT(selector), "changed", G_CALLBACK(set_source_callback), settings);
  GtkWidget* picker = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
					       HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
  hildon_button_set_title(HILDON_BUTTON(picker), "Source");
  hildon_button_set_value(HILDON_BUTTON(picker), settings->source);
  hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(picker),
				    HILDON_TOUCH_SELECTOR(selector));
  gtk_box_pack_start(GTK_BOX(area), picker, FALSE, FALSE,0);
}

static void create_led_check_buttons(GtkWidget* area, LedPulseSettings* settings)
{
  GtkWidget* red_led_box = gtk_hbox_new(TRUE, 0);
  GtkWidget* blue_led_box = gtk_hbox_new(TRUE, 0);
  GtkWidget* green_led_box = gtk_hbox_new(TRUE, 0);
  GtkWidget* keyboard_box_left = gtk_hbox_new(TRUE, 0);
  GtkWidget* keyboard_box_right = gtk_hbox_new(TRUE, 0);
  GtkWidget* keyboard1_led_box = gtk_hbox_new(TRUE, 0);
  GtkWidget* keyboard2_led_box = gtk_hbox_new(TRUE, 0);
  GtkWidget* keyboard3_led_box = gtk_hbox_new(TRUE, 0);
  GtkWidget* keyboard4_led_box = gtk_hbox_new(TRUE, 0);
  GtkWidget* keyboard5_led_box = gtk_hbox_new(TRUE, 0);
  GtkWidget* keyboard6_led_box = gtk_hbox_new(TRUE, 0);
  GtkWidget* red_led_check_button = hildon_check_button_new(HILDON_SIZE_AUTO);
  GtkWidget* blue_led_check_button = hildon_check_button_new(HILDON_SIZE_AUTO);
  GtkWidget* green_led_check_button = hildon_check_button_new(HILDON_SIZE_AUTO);
  GtkWidget* keyboard1_led_check_button = hildon_check_button_new(HILDON_SIZE_AUTO);
  GtkWidget* keyboard2_led_check_button = hildon_check_button_new(HILDON_SIZE_AUTO);
  GtkWidget* keyboard3_led_check_button = hildon_check_button_new(HILDON_SIZE_AUTO);
  GtkWidget* keyboard4_led_check_button = hildon_check_button_new(HILDON_SIZE_AUTO);
  GtkWidget* keyboard5_led_check_button = hildon_check_button_new(HILDON_SIZE_AUTO);
  GtkWidget* keyboard6_led_check_button = hildon_check_button_new(HILDON_SIZE_AUTO);

  gtk_button_set_label(GTK_BUTTON(red_led_check_button), "Red");
  gtk_button_set_label(GTK_BUTTON(blue_led_check_button), "Blue");
  gtk_button_set_label(GTK_BUTTON(green_led_check_button), "Green");
  gtk_button_set_label(GTK_BUTTON(keyboard1_led_check_button), "Keyboard 1");
  gtk_button_set_label(GTK_BUTTON(keyboard2_led_check_button), "Keyboard 2");
  gtk_button_set_label(GTK_BUTTON(keyboard3_led_check_button), "Keyboard 3");
  gtk_button_set_label(GTK_BUTTON(keyboard4_led_check_button), "Keyboard 4");
  gtk_button_set_label(GTK_BUTTON(keyboard5_led_check_button), "Keyboard 5");
  gtk_button_set_label(GTK_BUTTON(keyboard6_led_check_button), "Keyboard 6");

  gtk_box_pack_start(GTK_BOX(red_led_box), red_led_check_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(blue_led_box), blue_led_check_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(green_led_box), green_led_check_button, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(keyboard1_led_box), keyboard1_led_check_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(keyboard2_led_box), keyboard2_led_check_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(keyboard3_led_box), keyboard3_led_check_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(keyboard4_led_box), keyboard4_led_check_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(keyboard5_led_box), keyboard5_led_check_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(keyboard6_led_box), keyboard6_led_check_button, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(area), red_led_box, FALSE, FALSE, 3);
  gtk_box_pack_start(GTK_BOX(area), blue_led_box, FALSE, FALSE, 3);  
  gtk_box_pack_start(GTK_BOX(area), green_led_box, FALSE, FALSE, 3);  

  gtk_box_pack_start(GTK_BOX(area), keyboard_box_left, TRUE, TRUE, 3);  
  gtk_box_pack_start(GTK_BOX(area), keyboard_box_right, TRUE, TRUE, 3);  

  gtk_box_pack_start(GTK_BOX(keyboard_box_left), keyboard1_led_box, FALSE, FALSE, 3);  
  gtk_box_pack_start(GTK_BOX(keyboard_box_left), keyboard2_led_box, FALSE, FALSE, 3);  
  gtk_box_pack_start(GTK_BOX(keyboard_box_left), keyboard3_led_box, FALSE, FALSE, 3);  
  gtk_box_pack_start(GTK_BOX(keyboard_box_right), keyboard4_led_box, FALSE, FALSE, 3);  
  gtk_box_pack_start(GTK_BOX(keyboard_box_right), keyboard5_led_box, FALSE, FALSE, 3);  
  gtk_box_pack_start(GTK_BOX(keyboard_box_right), keyboard6_led_box, FALSE, FALSE, 3);  

  hildon_check_button_set_active(HILDON_CHECK_BUTTON(red_led_check_button), settings->red_led);
  hildon_check_button_set_active(HILDON_CHECK_BUTTON(blue_led_check_button), settings->blue_led);
  hildon_check_button_set_active(HILDON_CHECK_BUTTON(green_led_check_button), settings->green_led);
  hildon_check_button_set_active(HILDON_CHECK_BUTTON(keyboard1_led_check_button), settings->kb1_led);
  hildon_check_button_set_active(HILDON_CHECK_BUTTON(keyboard2_led_check_button), settings->kb2_led);
  hildon_check_button_set_active(HILDON_CHECK_BUTTON(keyboard3_led_check_button), settings->kb3_led);
  hildon_check_button_set_active(HILDON_CHECK_BUTTON(keyboard4_led_check_button), settings->kb4_led);
  hildon_check_button_set_active(HILDON_CHECK_BUTTON(keyboard5_led_check_button), settings->kb5_led);
  hildon_check_button_set_active(HILDON_CHECK_BUTTON(keyboard6_led_check_button), settings->kb6_led);

  g_signal_connect(G_OBJECT(red_led_check_button), "toggled", G_CALLBACK(checkBoxToggled), &settings->red_led);
  g_signal_connect(G_OBJECT(blue_led_check_button), "toggled", G_CALLBACK(checkBoxToggled), &settings->blue_led);
  g_signal_connect(G_OBJECT(green_led_check_button), "toggled", G_CALLBACK(checkBoxToggled), &settings->green_led);
  g_signal_connect(G_OBJECT(keyboard1_led_check_button), "toggled", G_CALLBACK(checkBoxToggled), &settings->kb1_led);
  g_signal_connect(G_OBJECT(keyboard2_led_check_button), "toggled", G_CALLBACK(checkBoxToggled), &settings->kb2_led);
  g_signal_connect(G_OBJECT(keyboard3_led_check_button), "toggled", G_CALLBACK(checkBoxToggled), &settings->kb3_led);
  g_signal_connect(G_OBJECT(keyboard4_led_check_button), "toggled", G_CALLBACK(checkBoxToggled), &settings->kb4_led);
  g_signal_connect(G_OBJECT(keyboard5_led_check_button), "toggled", G_CALLBACK(checkBoxToggled), &settings->kb5_led);
  g_signal_connect(G_OBJECT(keyboard6_led_check_button), "toggled", G_CALLBACK(checkBoxToggled), &settings->kb6_led);
}

static LedPulseSettingsDialog*
ledpulse_settings_dialog_create(LedPulseHomePlugin* plugin) {
  LedPulseSettingsDialog* settings_dialog = (LedPulseSettingsDialog*)g_malloc0(sizeof(LedPulseSettingsDialog));
  settings_dialog->settings = (LedPulseSettings*)g_malloc0(sizeof(LedPulseSettings));
  settings_dialog->plugin = plugin;
  ledpulse_settings_load(settings_dialog->settings);
  settings_dialog->dialog = gtk_dialog_new_with_buttons(_("Settings"),
							NULL, 0,
							GTK_STOCK_SAVE, GTK_RESPONSE_OK,
							GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);
  g_signal_connect(G_OBJECT(settings_dialog->dialog), "response",
		   G_CALLBACK(ledpulse_settings_dialog_response), settings_dialog);
  create_source_selection_box(GTK_WIDGET(gtk_dialog_get_content_area(GTK_DIALOG(settings_dialog->dialog))),
			      settings_dialog->settings);
  create_led_check_buttons(GTK_WIDGET(gtk_dialog_get_content_area(GTK_DIALOG(settings_dialog->dialog))),
			   settings_dialog->settings);

  return settings_dialog;
}

void ledpulse_settings_show(LedPulseHomePlugin* plugin)
{
  LedPulseSettingsDialog* settings_dialog = ledpulse_settings_dialog_create(plugin);
  gtk_widget_show_all(settings_dialog->dialog);
}

