#include "ledpulse-pulseaudio.h"
#include "ledpulse-home-plugin.h"

LedPulseAudio* ledpulse_pulseaudio_create() {
  return (LedPulseAudio*)g_malloc0(sizeof(LedPulseAudio));
}

static void context_state_callback(pa_context* context, void* userdata)
{
  LedPulseAudio* pa = (LedPulseAudio*)userdata;
  switch(pa_context_get_state(context)) {
  case PA_CONTEXT_READY:
    break;
  case PA_CONTEXT_FAILED:
    break;
  case PA_CONTEXT_UNCONNECTED:
    break;
  case PA_CONTEXT_CONNECTING:
    break;
  case PA_CONTEXT_AUTHORIZING:
    break;
  case PA_CONTEXT_SETTING_NAME:
    break;
  case PA_CONTEXT_TERMINATED:
    break;
  }
}

static void stream_state_callback(pa_stream* s, void* userdata)
{
  switch(pa_stream_get_state(s)) {
    case PA_STREAM_READY:
      break;
    case PA_STREAM_FAILED:
      break;
    case PA_STREAM_UNCONNECTED:
      break;
    case PA_STREAM_CREATING:
      break;
    case PA_STREAM_TERMINATED:
      break;
  }
}


static void stream_suspended_callback(pa_stream *s, void *userdata)
{
}

static void stream_read_callback(pa_stream *s, size_t nbytes, void *userdata)
{
  LedPulseHomePlugin* plugin = LEDPULSE_HOME_PLUGIN(userdata);
   const void* data;
  pa_stream_peek(s, &data, &nbytes);
  pa_stream_drop(s);
  if(nbytes<1)
    return;
  size_t i =0;
  double value = 0;
  for(i = 0; i < nbytes;++i) {
    //g_warning("data %f", ((const float*)data)[i]);
    value+=((const float*)data)[i];
  }
  ledpulse_home_plugin_process_audio_data(plugin, data, nbytes);
}

static void ledpulse_pulseaudio_disconnect_context(LedPulseAudio* pa) {
  if(pa->pulse_context)
  {
    pa_context_disconnect(pa->pulse_context);
    pa_context_unref(pa->pulse_context);
    pa->pulse_context = NULL;
  }
  if(pa->pulse_mainloop)
  {
    pa_glib_mainloop_free(pa->pulse_mainloop);
    pa->pulse_mainloop = NULL;
  }
}

void ledpulse_pulseaudio_enable_streaming(LedPulseAudio* pa, const gchar* source, void* data) {
  pa_buffer_attr attr;
  attr.fragsize = sizeof(float)*2;
  attr.maxlength = (uint32_t) -1;
  pa_sample_spec sample_spec;
  sample_spec.format = PA_SAMPLE_FLOAT32;
  sample_spec.rate = 25*2;
  sample_spec.channels = 1;
  pa->pulse_stream = pa_stream_new(pa->pulse_context, "LedPulse", &sample_spec, NULL);
  pa_stream_set_state_callback(pa->pulse_stream, stream_state_callback, pa);
  pa_stream_set_suspended_callback(pa->pulse_stream, stream_suspended_callback, pa);
  pa_stream_set_read_callback(pa->pulse_stream, stream_read_callback, data);
  pa_stream_connect_record(pa->pulse_stream, source, NULL/*&attr*/,PA_STREAM_DONT_MOVE|PA_STREAM_PEAK_DETECT|PA_STREAM_ADJUST_LATENCY);
}

void ledpulse_pulseaudio_disconnect_stream(LedPulseAudio* pa) {
  if(pa->pulse_stream)
  {
    pa_stream_disconnect(pa->pulse_stream);
    pa_stream_unref(pa->pulse_stream);
    pa->pulse_stream = NULL;
  }
}

void ledpulse_pulseaudio_dispose(LedPulseAudio** pa) {
  if(pa==NULL)
    return;
  ledpulse_pulseaudio_disconnect_stream(*pa);
  ledpulse_pulseaudio_disconnect_context(*pa);
  g_free(*pa);
  *pa = NULL;
}


void ledpulse_pulseaudio_init(LedPulseAudio* pa) {
  pa->pulse_mainloop = pa_glib_mainloop_new(g_main_context_default());
  pa->pulse_context = pa_context_new(pa_glib_mainloop_get_api(pa->pulse_mainloop), "LedPulse");
  pa_context_set_state_callback(pa->pulse_context, context_state_callback, pa);
  pa_context_connect(pa->pulse_context, NULL /* server NULL = Default*/, PA_CONTEXT_NOAUTOSPAWN, NULL /* spawn api */);
}
