#ifndef APICLIENT_H
#define APICLIENT_H

#include <QObject>
#include <QString>
#include <QMap>

#include "requests.h"
#include "utils.h"
#include "lastfmtrack.h"

class ApiClient : public QObject
{
    Q_OBJECT
public:
    explicit ApiClient(QString api_key, QString api_secret, QObject *parent = 0);
    void authGetMobileSession(QString username, QString password);
    void userShout(QString user, QString message, QString sk);
    void radioTune(QString station, QString sk);
    void radioGetPlaylist(QString sk);

private:
    QString api_key;
    QString api_secret;
    QString auth_token;

signals:
    void authGetMobileSessionData(QMap<QString, QString> reply);
    void userShoutData(QMap<QString, QString> reply);
    void radioTuneData(QMap<QString, QString> reply);
    void radioGetPlaylistData(QList<LastfmTrack*> tracks);

public slots:

private slots:
    void authGetMobileSessionReply(QString data);
    void userShoutReply(QString data);
    void radioTuneReply(QString data);
    void radioGetPlaylistReply(QString data);

};

#endif // APICLIENT_H
