#include "history.h"
#include <stdio.h>

History::History(int depth)
{
	fullDepth = depth;
	historyArray = new QPixmap *[fullDepth];
	for(int i=0; i<fullDepth; i++)
	{
		historyArray[i] = NULL;
	}
	current = -1;
	currentDepth = 0;
	nowAvailable = 0;
}

History::~History(void)
{
	//delete[] historyArray;
	/*for(int i=0; i<fullDepth; i++)
	{
		delete historyArray[i];
	}*/
}

void History::clear()
{
	delete[] historyArray;
	historyArray = new QPixmap *[fullDepth];
	current = -1;
	currentDepth = 0;
	nowAvailable = 0;
}

void History::saveState(QPixmap *state)
{
	if(current+1 <= fullDepth-1)
	{
		current++;
	}
	else
	{
		current = 0;
	}
	if(historyArray[current] != NULL)
	{
		QPaintDevice *obj = historyArray[current];
		delete obj;
	}
	historyArray[current] = new QPixmap(*state);
	if(currentDepth < fullDepth)
	{
		currentDepth++;
	}
	nowAvailable = 0;
}

bool History::undo()
{
	if(currentDepth-1 >= 1)
	{
		if(current-1 >= 0)
		{
			current--;
		}
		else
		{
			current = fullDepth-1;
		}
		currentDepth--;
		nowAvailable++;
		return true;
	}
	else
	{
		return false;
	}
	
}

bool History::redo()
{
	if(currentDepth+1 <= fullDepth && nowAvailable > 0)
	{
		if(current+1 > fullDepth-1)
		{
			current = 0;
		}
		else
		{
			current++;
		}
		nowAvailable--;
		currentDepth++;
		return true;
	}
	else
	{
		return false;
	}
}

QPixmap History::getState()
{
	if(current >= 0)
	{
		if(!historyArray[current][0].isNull())
		{
			return historyArray[current][0];
		}
		else
		{
			return NULL;
		}
	}
	else
	{
		return NULL;
	}
}
