#include "editwidget.h"
#include "stdio.h"
#include <QtGui>
EditWidget::EditWidget(QWidget *parent): QLabel(parent)
{
	this->setBackgroundRole(QPalette::Base);
	this->setSizePolicy(QSizePolicy::Ignored, QSizePolicy::Ignored);
	this->setScaledContents(true);
	
	pixmapHistory = new History(5);
	
	pen = new QPen(QColor(Qt::white),1);
    penSelect = new QPen(QColor(Qt::white),1);
    penSelect->setStyle(Qt::DashLine);
	pen->setJoinStyle(Qt::RoundJoin);
	pen->setCapStyle(Qt::RoundCap);
	
	prevPoint = QPointF(-1,-1);
    curPoint = QPointF(-1,-1);
	checkPen = false;
    selectRect = false;
}

EditWidget::~EditWidget()
{

}

void EditWidget::setImage(QString fname)
{
	QImage image(fname);
	if(!image.isNull())
	{
		pixmap = new QPixmap(fname);
		this->setPixmap(*pixmap);
		this->adjustSize();
	}
}
void EditWidget::paintEvent(QPaintEvent *event)
{
	QPainter qpainter (this);
	qpainter.drawPixmap(0,0,*pixmap);
}
void EditWidget::mouseReleaseEvent(QMouseEvent* pEvent)
{
	if(pEvent->button() == Qt::LeftButton)
	{
		QPainter painter(pixmap);
		if(prevPoint.x() == -1)
			return;
		if(checkPen){
			curPoint.setX(-1); 
            curPoint.setY(-1); 
			prevPoint.setX(-1);
            prevPoint.setY(-1);
            pixmapHistory->saveState(pixmap);
        }else if(selectRect){
			
		}else{
            pixmapHistory->saveState(pixmap);
        }
		
 		emit repaint();
	}
}
void EditWidget::mouseMoveEvent(QMouseEvent* pEvent)
{
		if(prevPoint.x() == -1)
			return;
		if(checkPen){
            QPainter painter(pixmap);
			painter.setPen(*pen);
			curPoint = pEvent->posF();
			painter.drawLine(prevPoint,curPoint);
			prevPoint = pEvent->posF();
		}else if(selectRect){
            *pixmap = saveSelectPix->copy(); 
	        emit repaint();            
            QPainter painter(pixmap);
			painter.setPen(*penSelect);
			curPoint = pEvent->posF();
			int w = curPoint.x()-prevPoint.x();
            int h = curPoint.y()-prevPoint.y();
            int x = prevPoint.x();
            int y = prevPoint.y();
            if(w < 0){
                w = w*(-1);
                x = x-w;            
            }
            if(h < 0){
                h = h*(-1);
                y = y-h;
            }		
        	painter.drawRect(x, y, w, h);
		}
			
		emit repaint();
}
void EditWidget::mousePressEvent(QMouseEvent* pEvent)
{
	prevPoint = pEvent->posF();
    curPoint = pEvent->posF();
}
void EditWidget::editChooseColor(QColor color)
{
	pen->setColor(color);
}
void EditWidget::editChangeSizeBrush(int size)
{
	pen->setWidth(size);
}
void EditWidget::drawRectSelect()
{
    if(!selectRect)
	{	
        selectRect = true;
        checkPen = false;
		//saveSelectPix = &(pixmap->copy());
		if(saveSelectPix != NULL)
		{
			deleteObject(saveSelectPix);
			saveSelectPix = NULL;
		}
		saveSelectPix  = new QPixmap(*pixmap);
	}
    else
	{
        removeSelect();
        curPoint.setX(-1); 
        curPoint.setY(-1); 
		prevPoint.setX(-1);
        prevPoint.setY(-1);
    }
}
void EditWidget::removeSelect()
{
	if(selectRect)
	{
		selectRect = false;
		if(saveSelectPix != NULL)
		{
			*pixmap = saveSelectPix->copy(); 
			deleteObject(saveSelectPix);
			saveSelectPix = NULL;
		}
	    emit repaint(); 
	}
}
void EditWidget::drawCropSelect()
{
    if((curPoint.x()!=-1) || (prevPoint.x()!=-1))
	{    
        int w = curPoint.x()-prevPoint.x();
        int h = curPoint.y()-prevPoint.y();
        int x = prevPoint.x();
        int y = prevPoint.y();
        if(w < 0){
            w = w*(-1);
            x = x-w;            
        }
        if(h < 0){
            h = h*(-1);
            y = y-h;
        }
		removeSelect();
        *pixmap = pixmap->copy(x, y, w, h);
		pixmapHistory->saveState(pixmap);
		this->resize(pixmap->size());
        //*saveSelectPix = pixmap->copy();    
        emit repaint();
        curPoint.setX(-1); 
        curPoint.setY(-1); 
		prevPoint.setX(-1);
        prevPoint.setY(-1);
    }
	else
	{
		QMessageBox::information(this, tr("KolibriLook"),
					   tr("Please, select cropping part of image!"),
					   QMessageBox::Ok); 
    }
}

void EditWidget::undo()
{
	if(pixmapHistory->undo())
	{
		deleteObject(this->pixmap);
		this->pixmap = new QPixmap(pixmapHistory->getState());
		if(this->pixmap->size() != this->size())
		{
			this->resize(pixmap->size());
		}
        //*saveSelectPix = pixmap->copy();
		emit repaint();
	}
}
void EditWidget::redo()
{
	if(pixmapHistory->redo())
	{
		deleteObject(this->pixmap);
		this->pixmap = new QPixmap(pixmapHistory->getState());
		if(this->pixmap->size() != this->size())
		{
			this->resize(pixmap->size());
		}
        //*saveSelectPix = pixmap->copy();
		emit repaint();
	}	
	
}
void EditWidget::rotate(int angle)
{
	QPixmap* old = pixmap;
	resize(pixmap->size().height(),pixmap->size().width());
	QPixmap* rotatedPixmap = new QPixmap(pixmap->size().height(),pixmap->size().width());
	QPainter p(rotatedPixmap);
	QSize size = pixmap->size();
	p.translate(size.height()/2,size.height()/2);
	p.rotate(angle);
	p.translate(-size.height()/2,-size.height()/2);
	p.drawPixmap(0, 0, *pixmap);
	p.end();

	pixmap = rotatedPixmap;
	delete old;
}
void EditWidget::rotateRight()
{
	removeSelect();
	rotate(90);
	pixmapHistory->saveState(pixmap);
	emit repaint();
}
void EditWidget::rotateLeft()
{
	removeSelect();
	rotate(90);
	rotate(90);
	rotate(90);
	pixmapHistory->saveState(pixmap);
	emit repaint();
}
void EditWidget::saveToHistory()
{
	pixmapHistory->saveState(this->pixmap);
}

void EditWidget::drawPenSelect()
{
	if(checkPen)
	{
		checkPen = false;
		//*saveSelectPix = pixmap->copy();
	}
	else if(selectRect)
	{
		checkPen = true;
		removeSelect();
	} 
	else
	{
		checkPen = true;
		selectRect = false;
	}	
 
}
void EditWidget::drawResize()
{
    QMessageBox* msg  = new QMessageBox(this);
    QLabel* label = new QLabel(tr("Please, type width and height a new image"));
    QLineEdit* width = new QLineEdit(tr("Width"), msg);
    QLineEdit* height = new QLineEdit(tr("Height"), msg );
    QVBoxLayout *vbox = new QVBoxLayout();

	removeSelect();
    vbox->addWidget(label, 1);
    vbox->addWidget(width, 1);
    vbox->addWidget(height, 1);
    msg->layout()->addItem(vbox);
    msg->exec();
    bool ok1, ok2;
    if(msg->result() != QDialog::Rejected)
	{
        int w = width->text().toInt(&ok1, 10); 
        int h = height->text().toInt(&ok2, 10);
        if(ok1 && ok2 && w>0 && h>0 && w<10000 && h<10000) 
		{ 
            *pixmap = pixmap->scaled(QSize(w, h));
            emit repaint();
			this->resize(pixmap->size());
            ///*saveSelectPix = pixmap->copy();
            pixmapHistory->saveState(pixmap);
		}else{
			QMessageBox mbx(this);
			mbx.setIcon(QMessageBox::Warning);
			mbx.setText(tr("Fields must be positive integer number, but no greater 10000!"));
			mbx.exec();
		}
       
	}
}
void EditWidget::deleteObject(QPaintDevice *obj)
{
	delete obj;
}

void EditWidget::makeGrayScale()
{
	//QPixmap temp = QPixmap::fromImage(pixmap->toImage().convertToFormat(QImage::Format_Mono));
	QImage tempImg = pixmap->toImage();
	make_grayscale(tempImg);
	QPixmap temp = QPixmap::fromImage(tempImg);
	*pixmap = temp;
	emit repaint();
}
void EditWidget::makeBlackAndWhite()
{
	QPixmap temp = QPixmap::fromImage(pixmap->toImage().convertToFormat(QImage::Format_Mono));
	*pixmap = temp;
	pixmapHistory->saveState(pixmap);
	emit repaint();
}
void EditWidget::make_grayscale(QImage& im)
{
	//QImage in = im.convertToFormat(QImage::Format_Indexed8);
/*	
    QImage in = im;
	
	QVector<QRgb> table(in.colorCount());
	for(int i=0;i<in.colorCount();i++)
	{
		QRgb c1=in.color(i);
		int avg=qGray(c1);
		table.append(qRgb(avg,avg,avg));
	}

    im = in.convertToFormat(QImage::Format_RGB32, table);
    */
	/*QVector<int> transform_table(in.numColors());

	for(int i=0;i<in.numColors();i++)
	{
		QRgb c1=in.color(i);
		int avg=qGray(c1);
		transform_table.append(avg);
	}
	in.setNumColors(256);
	for(int i=0;i<256;i++)
		in.setColor(i,qRgb(i,i,i));
	for(int i=0;i<in.numBytes();i++)
	{
		in.bits()[i]=transform_table[in.bits()[i]];
	}*/
	//im = in;
}
