/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import mso.generator.Choice;
import mso.generator.Limitation;
import mso.generator.Member;
import mso.generator.Struct;
import mso.generator.TypeRegistry;

class Option {
    Struct type;
    TypeRegistry.Type limitsType;
    Lim lim = new Lim();

    Option(Struct struct, TypeRegistry.Type type) {
        this.type = struct;
        this.setLimitations(struct, type);
    }

    Option(Struct struct) {
        this.type = struct;
        this.setLimitations(struct, null);
    }

    private void setLimitations(Choice choice) {
        this.lim.lims = new Lim[choice.options.size()];
        for (int i = 0; i < choice.options.size(); ++i) {
            this.lim.lims[i] = choice.options.get((int)i).lim;
        }
        this.limitsType = choice.commonType;
    }

    private void setLimitations(Struct struct, TypeRegistry.Type type) {
        Member member = struct.members.get(0);
        if (member.isOptional) {
            throw new Error("choice member may not be optional");
        }
        TypeRegistry.Type type2 = member.type();
        if (type2 instanceof Choice) {
            this.setLimitations((Choice)type2);
            return;
        }
        if (type2 == type) {
            this.lim.limitations = member.limitations;
            this.limitsType = type;
            return;
        }
        if (member.limitations.length == 0) {
            this.setLimitations((Struct)type2, type);
            return;
        }
        this.lim.limitations = member.limitations;
        this.limitsType = type2;
    }

    class Lim {
        Limitation[] limitations;
        Lim[] lims;

        Lim() {
        }

        boolean containsCommonLimitation(Limitation limitation) {
            if (this.limitations != null) {
                for (int i = 0; i < this.limitations.length; ++i) {
                    if (!this.limitations[i].equals(limitation)) continue;
                    return true;
                }
            }
            return false;
        }

        void removeLimitation(Limitation limitation) {
            if (!this.containsCommonLimitation(limitation)) {
                return;
            }
            if (this.limitations != null) {
                Limitation[] limitationArray = new Limitation[this.limitations.length - 1];
                int n = 0;
                for (int i = 0; i < this.limitations.length; ++i) {
                    if (this.limitations[i].equals(limitation)) continue;
                    limitationArray[n++] = this.limitations[i];
                }
                this.limitations = limitationArray;
            }
        }
    }
}

