/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import mso.generator.Choice;
import mso.generator.Limitation;
import mso.generator.MSO;
import mso.generator.Member;
import mso.generator.Option;
import mso.generator.QtParserGenerator;
import mso.generator.Struct;
import mso.generator.TypeRegistry;

public class QtApiGenerator {
    public final QtApiConfiguration config = new QtApiConfiguration();
    private final String generatedWarning = "/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */";

    private String type(Member member) {
        return this.type(member.type());
    }

    private String type(TypeRegistry.Type type) {
        TypeRegistry typeRegistry = type.registry;
        if (type == typeRegistry.bit) {
            return "bool";
        }
        if (type == typeRegistry.uint2 || type == typeRegistry.uint3 || type == typeRegistry.uint4 || type == typeRegistry.uint5 || type == typeRegistry.uint6 || type == typeRegistry.uint7 || type == typeRegistry.uint8) {
            return "quint8";
        }
        if (type == typeRegistry.uint9 || type == typeRegistry.uint12 || type == typeRegistry.uint14 || type == typeRegistry.uint15 || type == typeRegistry.uint16) {
            return "quint16";
        }
        if (type == typeRegistry.uint20 || type == typeRegistry.uint30 || type == typeRegistry.uint32) {
            return "quint32";
        }
        if (type == typeRegistry.int16) {
            return "qint16";
        }
        if (type == typeRegistry.int32) {
            return "qint32";
        }
        return type.name;
    }

    void generate(MSO mSO) throws IOException {
        FileWriter fileWriter = this.config.createHeader ? new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".h") : new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".cpp");
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
        if (this.config.createHeader) {
            printWriter.println("#ifndef " + this.config.basename.toUpperCase() + "_H");
            printWriter.println("#define " + this.config.basename.toUpperCase() + "_H");
        }
        printWriter.println("#include \"leinput.h\"");
        printWriter.println("namespace " + this.config.namespace + "{");
        for (Struct type : mSO.structs) {
            printWriter.println("class " + type.name + ";");
        }
        for (Choice choice : mSO.choices) {
            printWriter.println("class " + choice.name + ";");
        }
        for (Struct struct : mSO.structs) {
            this.printStructureClassDeclaration(printWriter, struct);
        }
        for (Choice choice : mSO.choices) {
            this.printChoiceClassDeclaration(printWriter, choice);
        }
        if (this.config.createHeader) {
            printWriter.println("} // close namespace");
            printWriter.println("#endif");
            printWriter.close();
            fileWriter = new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".cpp");
            printWriter = new PrintWriter(fileWriter);
            printWriter.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
            printWriter.println("#include \"" + this.config.basename + ".h\"");
        }
        for (Struct struct : mSO.structs) {
            this.printStructureDefinition(printWriter, struct);
        }
        if (!this.config.createHeader) {
            printWriter.println("}");
        }
        printWriter.close();
        fileWriter.close();
    }

    private void printStructureClassDeclaration(PrintWriter printWriter, Struct struct) {
        printWriter.println("class " + struct.name + " {");
        printWriter.println("public:");
        printWriter.println("    const char* _data;");
        if (struct.size == -1) {
            printWriter.println("    quint32 _size;");
            printWriter.println("    " + struct.name + "() :_data(0), _size(0) {}");
            printWriter.println("    " + struct.name + "(const char* data, const quint32 size);");
        } else {
            printWriter.println("    static const quint32 _size;");
            printWriter.println("    " + struct.name + "() :_data(0) {}");
            printWriter.println("    " + struct.name + "(const char* data);// " + struct.size / 8 + " bytes");
        }
        for (Member member : struct.members) {
            this.printMemberDeclaration(printWriter, member);
        }
        for (Member member : struct.members) {
            if (!member.isSimple || member.condition == null) continue;
            printWriter.println("    bool _has_" + member.name + ";");
        }
        printWriter.println("};");
    }

    private void printChoiceClassDeclaration(PrintWriter printWriter, Choice choice) {
        printWriter.println("class " + choice.name + " {");
        printWriter.println("public:");
        printWriter.println("    const char* _data;");
        if (choice.size == -1) {
            printWriter.println("    quint32 _size;");
            printWriter.println("    " + choice.name + "() :_data(0), _size(0) {}");
            printWriter.println("    " + choice.name + "(const char* data, const quint32 size);");
        } else {
            printWriter.println("    static const quint32 _size;");
            printWriter.println("    " + choice.name + "() :_data(0) {}");
            printWriter.println("    " + choice.name + "(const char* data);// " + choice.size / 8 + " bytes");
        }
        printWriter.println("};");
    }

    private String definitionPrefix() {
        return this.config.namespace == null || this.config.namespace.length() == 0 ? "" : this.config.namespace + "::";
    }

    private void printStructureDefinition(PrintWriter printWriter, Struct struct) {
        String string = this.definitionPrefix() + struct.name + "::";
        if (struct.size == -1) {
            printWriter.println(string + struct.name + "(const char* _d, quint32 _maxsize) :_data(0), _size(0)");
            printWriter.println("{");
        } else {
            printWriter.println("const quint32 " + string + "_size = " + struct.size / 8 + ";");
            printWriter.println(string + struct.name + "(const char* _d) :_data(0)");
            printWriter.println("{");
        }
        printWriter.println("    quint32 _position = 0;");
        printWriter.println("    quint32 _msize;");
        int n = 0;
        for (Member member : struct.members) {
            String string2 = "    ";
            int n2 = this.getSize(member);
            String string3 = member.condition;
            if (member.isSimple && string3 != null) {
                printWriter.println(string2 + "_has_" + member.name + " = " + string3 + ";");
                string3 = "_has_" + member.name;
            }
            if (string3 != null) {
                printWriter.println(string2 + "if (" + string3 + ") {");
                string2 = "        ";
            }
            if (n2 != -1 && struct.size == -1) {
                printWriter.print(string2 + "if (_position + " + n2);
                if (member.isOptional) {
                    string2 = string2 + "    ";
                    printWriter.println(" <= _maxsize) {");
                } else {
                    printWriter.println(" > _maxsize) return;");
                }
            }
            n = this.printMemberParser(printWriter, string2, struct, member, n);
            this.printLimitationCheck(printWriter, string2, member.name, member);
            printWriter.println(string2 + "_position += _msize;");
            while (string2.length() > 4) {
                string2 = string2.substring(string2.length() - 4);
                printWriter.println(string2 + "}");
            }
        }
        if (struct.size == -1) {
            printWriter.println("    _size = _position;");
        }
        printWriter.println("    _data = _d;");
        printWriter.println("}");
        for (Member member : struct.members) {
            if (!member.isArray || !member.isStruct) continue;
            this.printStructArrayAccessor(printWriter, struct, member);
        }
    }

    private int printMemberParser(PrintWriter printWriter, String string, Struct struct, Member member, int n) {
        if (member.isArray) {
            if (member.isSimple) {
                this.printSimpleArrayMemberParser(printWriter, string, struct, member);
            } else {
                this.printStructArrayMemberParser(printWriter, string, struct, member);
            }
            if (member.isChoice) {
                throw new Error("There should be no choice in an array.");
            }
        } else {
            if (member.isSimple) {
                return this.printSimpleMemberParser(printWriter, string, struct, member, n);
            }
            if (member.isStruct) {
                this.printStructMemberParser(printWriter, string, struct, member);
            } else if (member.isChoice) {
                this.printChoiceMemberParser(printWriter, string, struct, member);
            }
        }
        return 0;
    }

    private int printSimpleMemberParser(PrintWriter printWriter, String string, Struct struct, Member member, int n) {
        printWriter.println(string + member.name + " = read" + member.type().name + (n > 0 ? "_" + String.valueOf(n) : "") + "(_d + _position);");
        int n2 = member.type().size / 8;
        if (n != 0 && (n + member.type().size) % 8 == 0) {
            ++n2;
        }
        n = (n + member.type().size) % 8;
        printWriter.println(string + "_msize = " + n2 + ";");
        return n;
    }

    private int getSize(Member member) {
        int n = -1;
        if (member.count != null && member.isArray && member.type().size != -1) {
            try {
                n = member.type().size * Integer.parseInt(member.count) / 8;
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        } else if (member.size != null) {
            try {
                n = Integer.parseInt(member.size);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        } else if (!member.isArray) {
            return member.type().size / 8;
        }
        return n;
    }

    private void printSimpleArrayMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        if (member.type().size % 8 != 0) {
            throw new Error("only arrays of types with a size of a multiple of 8 bits are allowed.");
        }
        int n = this.getSize(member);
        String string2 = String.valueOf(n * 8 / member.type().size);
        if (n == -1) {
            string2 = member.count != null ? member.count : "(" + member.size + ")/" + member.type().size / 8;
        } else if (n % (member.type().size / 8) != 0) {
            throw new Error("array size must be a multiple of the size of the type for " + member.type().name + " and size " + n);
        }
        printWriter.println(string + member.name + "Count = " + string2 + ";");
        printWriter.println(string + "_msize = " + member.name + "Count*" + member.type().size / 8 + ";");
        printWriter.println(string + member.name + " = (const " + this.type(member) + "*)(_d + _position);");
    }

    private void printStructArrayMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        if (member.count != null || member.size != null) {
            this.printStructFixedArrayMemberParser(printWriter, string, struct, member);
            return;
        }
        printWriter.println(string + "_msize = 0;");
        printWriter.println(string + member.name + "Count = 0;");
        printWriter.println(string + "while (_position < _maxsize) {");
        if (member.type().size == -1) {
            printWriter.println(string + "    " + member.type().name + " _v(_d + _position + _msize, _maxsize - _position - _msize);");
        } else {
            if (struct.size == -1) {
                printWriter.println(string + "    if (_maxsize - _position - _msize < " + member.type().size / 8 + ") return;");
            }
            printWriter.println(string + "    " + member.type().name + " _v(_d + _position + _msize);");
        }
        printWriter.println(string + "    if (_v._data == 0) break;");
        printWriter.println(string + "    _msize += _v._size;");
        printWriter.println(string + "    " + member.name + "Count++;");
        printWriter.println(string + "}");
    }

    private void printStructFixedArrayMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        printWriter.println(string + "_msize = 0;");
        if (member.count != null) {
            printWriter.println(string + member.name + "Count = " + member.count + ";");
            printWriter.println(string + "for (quint32 i=0; i<" + member.name + "Count; ++i) {");
        } else {
            printWriter.println(string + member.name + "Count = 0;");
            printWriter.println(string + "quint32 _lsize = " + member.size + ";");
            printWriter.println(string + "while (_msize < _lsize) {");
        }
        if (member.type().size == -1) {
            printWriter.println(string + "    " + member.type().name + " _v(_d + _position + _msize, _maxsize - _position - _msize);");
        } else {
            if (struct.size == -1) {
                printWriter.println(string + "    if (_maxsize - _position - _msize < " + member.type().size / 8 + ") return;");
            }
            printWriter.println(string + "    " + member.type().name + " _v(_d + _position + _msize);");
        }
        printWriter.println(string + "    if (_v._data == 0) return;");
        printWriter.println(string + "    _msize += _v._size;");
        if (member.count != null) {
            printWriter.println(string + "}");
        } else {
            printWriter.println(string + "    " + member.name + "Count++;");
            printWriter.println(string + "}");
            printWriter.println(string + "if (_msize != _lsize) return;");
        }
    }

    private void printStructMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        if (member.type().size == -1) {
            printWriter.println(string + member.name + " = " + member.type().name + "(_d + _position, _maxsize - _position);");
        } else {
            printWriter.println(string + member.name + " = " + member.type().name + "(_d + _position);");
        }
        if (member.isOptional) {
            printWriter.println(string + "_msize = (" + member.name + "._data) ?" + member.name + "._size :0;");
        } else {
            printWriter.println(string + "if (" + member.name + "._data == 0) return;");
            printWriter.println(string + "_msize = " + member.name + "._size;");
        }
    }

    private void printChoiceMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        Choice choice = (Choice)member.type();
        boolean bl = true;
        for (Option option : choice.options) {
            Struct struct2 = option.type;
            if (!bl) {
                printWriter.println(string + "if (_msize == 0) {");
                printWriter.print(string);
            }
            if (struct2.size == -1) {
                printWriter.println(string + "_msize = " + struct2.name + "(_d + _position, _maxsize - _position)._size;");
            } else {
                printWriter.println(string + "_msize = (" + struct2.name + "(_d + _position)._data) ?" + struct2.name + "::_size :0;");
            }
            if (!bl) {
                printWriter.println(string + "}");
            }
            bl = false;
        }
        if (!member.isOptional) {
            printWriter.println(string + "if (_msize == 0) return;");
        }
    }

    private String getTypeName(TypeRegistry.Type type) {
        TypeRegistry typeRegistry = type.registry;
        if (type instanceof Choice) {
            return type.name;
        }
        if (type == typeRegistry.bit) {
            return "bool";
        }
        if (type == typeRegistry.uint2 || type == typeRegistry.uint3 || type == typeRegistry.uint4 || type == typeRegistry.uint5 || type == typeRegistry.uint6 || type == typeRegistry.uint7 || type == typeRegistry.uint8) {
            return "quint8";
        }
        if (type == typeRegistry.uint9 || type == typeRegistry.uint12 || type == typeRegistry.uint14 || type == typeRegistry.uint15 || type == typeRegistry.uint16) {
            return "quint16";
        }
        if (type == typeRegistry.uint20 || type == typeRegistry.uint30 || type == typeRegistry.uint32) {
            return "quint32";
        }
        if (type == typeRegistry.int16) {
            return "qint16";
        }
        if (type == typeRegistry.int32) {
            return "qint32";
        }
        return type.name;
    }

    private void printStructArrayAccessor(PrintWriter printWriter, TypeRegistry.Type type, Member member) {
        String string = this.definitionPrefix();
        String string2 = member.type().name;
        printWriter.println(string + string2 + " " + string + type.name + "::" + member.name + "(quint32 _i) const {");
        if (member.type().size == -1) {
            printWriter.println("    " + string + string2 + " _v(_data + " + member.name + "Offset, _size-" + member.name + "Offset);");
            printWriter.println("    quint32 _offset = " + member.name + "Offset + _v._size;");
            printWriter.println("    while (_i-- && _v._size) {");
            printWriter.println("        _v = " + string + string2 + "(_data + _offset, _size - _offset);");
            printWriter.println("        _offset += _v._size;");
            printWriter.println("    }");
            printWriter.println("    return _v;");
        } else {
            printWriter.println("    if (_i >= " + member.name + "Count) return " + string + string2 + "();");
            printWriter.print("    return " + string + string2 + "(_data + " + member.name + "Offset + _i*" + member.type().size / 8 + ");");
            printWriter.println("    ");
        }
        printWriter.println("}");
    }

    private void printMemberDeclaration(PrintWriter printWriter, Member member) {
        String string = this.getTypeName(member.type());
        if (member.isArray) {
            printWriter.println("    quint32 " + member.name + "Count;");
            if (member.isSimple) {
                printWriter.println("    const " + string + "* " + member.name + ";");
            }
            if (member.isStruct || member.isChoice) {
                printWriter.println("    quint32 " + member.name + "Offset;");
                printWriter.println("    " + string + " " + member.name + "(quint32 i) const;");
            }
        } else if (member.isChoice) {
            printWriter.println("    " + string + " " + member.name + "() const;");
        } else {
            printWriter.println("    " + string + " " + member.name + ";");
        }
    }

    private void printLimitationCheck(PrintWriter printWriter, String string, String string2, Member member) {
        if (member.type() instanceof Choice) {
            return;
        }
        for (Limitation limitation : member.limitations) {
            String string3;
            String string4 = limitation.name;
            string4 = !"".equals(string4) ? string2 + "." + string4 : string2;
            if (!member.isStruct) {
                string4 = "((" + this.getTypeName(member.type()) + ")" + string4 + ")";
            }
            string3 = (string3 = limitation.expression) == null ? QtParserGenerator.getCondition(string4, limitation) : QtParserGenerator.getExpression(string4, string3);
            printWriter.println(string + "if (!(" + string3 + ")) {");
            printWriter.println(string + "     return;");
            printWriter.println(string + "}");
        }
    }

    public class QtApiConfiguration {
        public String namespace;
        public String outputdir;
        public String basename;
        public boolean createHeader;
    }
}

