using GLib;
using Gtk;
using Hildon;
using Soup;
using Xml;
using Osso;

public class Player : PageWidget
{
	string player_id;
	private string address;
	private string fetch_address;
	private string fetch_username;
	private string fetch_password;
	private int playing;
	private int last_played;
	private HashTable<string,string> status;
	private Hildon.Seekbar seekbar;
	private int seekable = -1;
	private bool automatic_seek;
	private Gtk.Label info;
	private GLib.TimeVal last_seek;
	private GLib.TimeVal last_update;
	public int ITEM = 0;
	public int ARTIST = 1;
	public int ALBUM = 2;
	public int PLAYLIST = 3;
	public int RESULTSET = 4;
	public int SHARE = 5;
	public int RETURN_PAGE;
	private bool fullscreen;
	Scroller scroller;
	private string restart_ids;
	private int restart_type;
	private bool updating;
	private bool seeking;
	private bool stopping;
	private int rotation_before_playback;
	Gtk.HBox timedisplay;
	Gtk.HBox hb;
	Label current_position;
	Scroller now_playing;
	int64 wid;
	bool waiting_for_response;
	Gtk.DrawingArea embed;
	private string url;
	private string display_text;
	private KnotsPlayerBackend knotsplayer;
	
	construct {
		last_update = TimeVal();
		playing = 0;
		last_played = -1;
		stopping = false;
	}
	
	public override void add_signals()
	{
		get_toolbar_button(0).clicked += () => {
			go_back();
		};
		get_toolbar_button(1).clicked += () => {
			on_stop(false);
		};
		get_toolbar_button(2).clicked += () => {
			fetch_info(true);
		};
		get_toolbar_button(3).clicked += () => {
			fetch_info(false);
		};
		get_toolbar_button(4).clicked += () => {
			loop(true);
		};
		get_toolbar_button(5).clicked += () => {
			loop(false);
		};
		get_toolbar_button(6).clicked += () => {
			rate();
		};
		get_toolbar_button(7).clicked += () => {
			previous_item();
		};
		get_toolbar_button(8).clicked += () => {
			next_item();
		};
		
		seekbar.value_changed += () => {
			last_seek.get_current_time();
			if (!automatic_seek && !seeking)
			{
				seeking = true;
			}
			update_timedisplay(seekbar.get_position(), true);	
		};
	}
	
	public void rate()
	{
		int now_playing = this.playing;
		var dialog = new PickerDialog (get_knots().get_window());
		gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
		dialog.set_title("Rate");
		ListStore rating = new ListStore (1, typeof (string));
		TreeIter iter;
		for (int i = 0; i < 10; i++) {
			rating.append (out iter);
			rating.set_value(iter, 0, "" + (i + 1).to_string());
		}
		var selector = new TouchSelector ();
		selector.append_text_column (rating, true);
		dialog.set_selector (selector);
		selector.set_active(0, 4);
		var res = dialog.run ();
		if (res == ResponseType.OK)
		{
			get_knots().get_connection().set_url_cache(false);
			get_knots().get_connection().fetch_from_address("/external/rate?id=" + now_playing.to_string() + "&rating=" + (selector.get_active(0) + 1).to_string(), fetch_address, fetch_username, fetch_password);
			if (is_playing_music())
			{
				fetch_info(false);
			}
		}
		dialog.destroy();
	}
	
	public void go_back()
	{
		this.get_knots().get_page(RETURN_PAGE).reveal();
		check_update_need();
	}
	
	public override void orientation_change()
	{
		if (get_toolbar() != null)
		{
			if (get_knots().ORIENTATION == get_knots().LANDSCAPE)
			{
				reorder_child(get_toolbar(), 2);
				((Gtk.VBox)get_content()).reorder_child(timedisplay, 0);
				((Gtk.VBox)get_content()).remove(now_playing);
				now_playing.width_request = 180;
				now_playing.height_request = -1;
				hb.pack_start(now_playing, false, true, 0);
				now_playing.set_scroll_policy(true, false);
			}
			else
			{
				reorder_child(get_toolbar(), 0);
				hb.remove(now_playing);
				now_playing.height_request = 180;
				now_playing.width_request = -1;
				((Gtk.VBox)get_content()).pack_start(now_playing, false, true, 0);
				((Gtk.VBox)get_content()).reorder_child(timedisplay, 2);
				now_playing.set_scroll_policy(false, true);
			}
			reorder_now_playing();
			this.info.set_markup(this.info.get_label());
			
		}
	}
	
	public override Gtk.Widget create_content()
	{
		last_seek = TimeVal();
		seekbar = new Hildon.Seekbar();
		seekbar.height_request = 60;
		Gtk.VBox vbox = new Gtk.VBox(false, 2);
		info = new Gtk.Label("");
		info.set_line_wrap(true);
		get_knots().change_foreground_color(info, "#fff");
		Gtk.Fixed f = new Gtk.Fixed();
		f.put(info, 10, 10);
		scroller = new Scroller(f);
		timedisplay = new Gtk.HBox(false, 0);
		current_position = new Gtk.Label("");
		get_knots().change_foreground_color(current_position, "#fff");
		current_position.width_request = 200;
		timedisplay.pack_start(seekbar, true, true, 0);
		timedisplay.pack_start(current_position, false, false, 0);
		vbox.pack_start(timedisplay, false, true, 0);
		scroller.set_scroll_policy(false, true);
		hb = new Gtk.HBox(false, 0);
		hb.pack_start(scroller, true, true, 2);
		embed = new Gtk.DrawingArea();
		embed.add_events(Gdk.EventMask.BUTTON_PRESS_MASK);
		embed.button_press_event += toggle_controls;
		hb.pack_start(embed, true, true, 0);
		embed.hide();
		Gtk.Fixed ff = new Gtk.Fixed();
		now_playing = new Scroller(ff);
		now_playing.enable_clicking(false);
		now_playing.hide();
		now_playing.set_scroll_policy(true, false);
		if (get_knots().ORIENTATION == get_knots().LANDSCAPE)
		{
			now_playing.width_request = 180;
			now_playing.height_request = -1;
			hb.pack_start(now_playing, false, true, 0);
		}
		else
		{
			now_playing.height_request = 180;
			now_playing.width_request = -1;
			vbox.pack_start(now_playing, false, true, 0);
		}
		vbox.pack_start(hb, true, true, 0);
		return vbox;
	}
	
	public void loop(bool looped)
	{
		if (looped)
		{
			get_toolbar_button(4).hide();
			get_toolbar_button(5).show();
		}
		else
		{
			get_toolbar_button(4).show();
			get_toolbar_button(5).hide();
		}
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch_from_address("/external/loop?player_id=" + player_id + "&loop=" + looped.to_string(), fetch_address, fetch_username, fetch_password);
	}
	
	public override string[] get_toolbar_items()
	{
		return {"back", "stop", "lyrics", "info", "repeat", "no_repeat", "rate", "prev", "next"};
	}
	
	public void seek(double? new_position)
	{
		if (!automatic_seek && seekable == 1)
		{
			double total_time = (double)seekbar.get_total_time();
			if (total_time > 0)
			{
				double position = (double)seekbar.get_position() / total_time;
				if (new_position != null)
					position = new_position;
				if (position > 1.0)
					position = 1.0;
				else
				if (position < 0)
					position = 0;
				get_knots().get_connection().set_url_cache(false);
				get_knots().get_connection().fetch_from_address("/external/seek?player_id=" + player_id + "&position=" + position.to_string(), fetch_address, fetch_username, fetch_password);
			}
			seeking = false;
		}
	}
	
	public void next_item()
	{
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch_from_address("/external/next_playlist_item?player_id=" + player_id, fetch_address, fetch_username, fetch_password);
		update_status();
		handle_media_change();
	}
	
	public void previous_item()
	{
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch_from_address("/external/previous_playlist_item?player_id=" + player_id, fetch_address, fetch_username, fetch_password);
		update_status();
		handle_media_change();
	}
	
	public void fetch_info(bool lyrics)
	{
		gtk_window_set_progress_indicator(get_knots().get_window(), 1);
		get_toolbar_button(2).set_sensitive(false);
		get_toolbar_button(3).set_sensitive(false);
		get_knots().get_connection().set_url_cache(lyrics);
		url = "/external/" + (lyrics ? "lyrics" : "info") + "?id=" + playing.to_string();
		try
		{
			Thread.create(update_info_in_thread, true);
		}
		catch (ThreadError e)
		{
		
		}
	}
	
	public void* update_info_in_thread()
	{
		display_text = get_knots().get_connection().fetch_from_address(url, fetch_address, fetch_username, fetch_password);
		GLib.Idle.add(info_done);
		return null;
	}
	
	public bool info_done()
	{
		if (display_text != null && display_text.strip() != "")
		{
			set_info(display_text);
		}
		else
		if (url != null && url.str("lyrics") != null)
			get_knots().alert("No lyrics found");
		get_toolbar_button(2).set_sensitive(true);
		get_toolbar_button(3).set_sensitive(true);
		gtk_window_set_progress_indicator(get_knots().get_window(), 0);
		if (url != null && url.str("lyrics") != null)
		{
			get_toolbar_button(2).hide();
			get_toolbar_button(3).show();
		}
		else
		{
			get_toolbar_button(3).hide();
			get_toolbar_button(2).show();
		}
		return false;
	}
	
	public void set_info(string? info = null)
	{
		if (info != null)
			this.info.set_markup(info);
		else
			this.info.set_markup(display_text);
		scroller.scroll_to_top();
	}

	public void on_stop(bool force)
	{
		if (!stopping && !force)
		{
			this.knotsplayer.stop();
			stopping = true;
		}
		else
		{
			this.knotsplayer.force_stop();
		}
	}
	
	public void update_status_in_thread()
	{
		try
		{
			Thread.create(update_server_status, true);
		}
		catch (ThreadError e)
		{
		}
	}
	
	public void* update_server_status()
	{
		update_status();
		if (!fullscreen)
			GLib.Idle.add(update_seekbar);
		if ((get_player_value("media_id")).to_int() != playing)
			GLib.Idle.add(handle_media_change);
		return null;
	}
	
	public bool update_status()
	{
		waiting_for_response = true;
		get_knots().get_connection().set_url_cache(false);
		string xml = get_knots().get_connection().fetch_from_address("/external/player_properties?player_id=" + player_id, fetch_address, fetch_username, fetch_password);
		XMList list = new XMList(xml);
		if (list != null && list.itemcount() == 1)
		{
			status = list.items()[0];
		}
		waiting_for_response = false;
		last_update.get_current_time();
		return status != null;
	}
	
	public void set_automatic_position(int position)
	{
		automatic_seek = true;
		seekbar.set_position(position);
		automatic_seek = false;
	}
	
	public void return_to_player()
	{
		this.RETURN_PAGE = 0;
		this.get_knots().get_player().reveal();
	}
	
	public bool handle_media_change()
	{
		get_toolbar_button(2).show();
		get_toolbar_button(3).hide();
		this.playing = (get_player_value("media_id")).to_int();
		int index = (get_player_value("playlistindex")).to_int();
		int playlist_length = (get_player_value("playlist_length")).to_int();
		seekable = 0;
		if (get_player_value("seekable") == "true")
		{
			seekbar.set_total_time((get_player_value("duration")).to_int());
			timedisplay.show();
			update_timedisplay(null, false);
			update_seekbar();
			seekable = 1;
		}
		if (get_player_value("looped") == "false")
		{
			get_toolbar_button(4).show();
			get_toolbar_button(5).hide();
		}
		else
		{
			get_toolbar_button(4).hide();
			get_toolbar_button(5).show();
		}
		set_info("");
		if (is_playing_music())
		{
			unfullscreen();
			get_toolbar_button(7).hide();
			get_toolbar_button(8).hide();
			get_toolbar_button(0).show();
			get_toolbar_button(2).show();
			get_knots().get_connection().set_url_cache(false);
			set_info(get_knots().get_connection().fetch_from_address("/external/info?id=" + this.playing.to_string(), fetch_address, fetch_username, fetch_password));
			revert_rotation();
			if (playlist_length > 1)
			{
				highlight_item(index - 1);
			}
		}
		else
		{
			fullscreen_video();
			get_knots().get_window().set_icon(get_knots().get_common().get_app_icon());
			rotation_before_playback = get_knots().get_rotation();
			if (rotation_before_playback == 1 || rotation_before_playback == 3)
			{
				get_knots().set_rotation(0);
			}
			get_toolbar_button(0).hide();
			get_toolbar_button(2).hide();
			get_toolbar_button(7).show();
			get_toolbar_button(8).show();
			get_toolbar_button(8).set_sensitive(index < playlist_length);
			get_toolbar_button(7).set_sensitive(index > 1);
		}
		window.set_title("Knots - " + get_player_value("title"));
		scroller.scroll_to_top();
		check_update_need();
		return false;
	}

	public int get_position_sec()
	{
		return (int)(seekbar.get_position() * seekbar.get_total_time());
	}
	
	public bool play(string id, int playback_type)
	{
		if (!this.is_playing())
		{
			seeking = false;
			this.waiting_for_response = false;
			fetch_address = this.get_knots().get_connection().address();
			fetch_username = this.get_knots().get_connection().username();
			fetch_password = this.get_knots().get_connection().password();
			get_toolbar_button(2).show();
			get_toolbar_button(3).hide();
			get_toolbar_button(4).hide();
			get_toolbar_button(5).hide();
			this.rotation_before_playback = -1;
			this.seeking = false;
			this.updating = false;
			this.fullscreen = false;
			this.get_knots().get_player().reveal();
			get_knots().get_browser().get_toolbar_button(4).hide();
			get_knots().get_browser().get_toolbar_button(5).show();
			timedisplay.hide();
			set_automatic_position(0);
			player_id = null;
			string profile = get_knots().get_settings().get_value_default_to("transcoding_profile", "6");
			get_knots().get_connection().set_url_cache(false);
			string lang = "";
			if (get_knots().get_settings().get_value("audio_language") != null)
			{
				lang = "&audio_language=" + get_knots().get_settings().get_value("audio_language") + ",any&subtitle_language=" + get_knots().get_settings().get_value("subtitle_language"); 
			}
			if (playback_type == ITEM)
			{
				player_id = get_knots().get_connection().fetch_from_address("/external/play?profile=" + profile + "&id=" + id + lang, fetch_address, fetch_username, fetch_password).split("\n")[0];
				this.RETURN_PAGE = 1;
			}
			else
			if (playback_type == ARTIST)
			{
				player_id = get_knots().get_connection().fetch_from_address("/external/play_artist?profile=" + profile + "&id=" + id, fetch_address + lang, fetch_username, fetch_password).split("\n")[0];
				this.RETURN_PAGE = 1;
			}
			else
			if (playback_type == ALBUM)
			{
				player_id = get_knots().get_connection().fetch_from_address("/external/play_album?profile=" + profile + "&id=" + id, fetch_address + lang, fetch_username, fetch_password).split("\n")[0];
				this.RETURN_PAGE = 1;
			}
			else
			if (playback_type == PLAYLIST)
			{
				player_id = get_knots().get_connection().fetch_from_address("/external/play_playlist?profile=" + profile + "&id=" + id + lang, fetch_address, fetch_username, fetch_password).split("\n")[0];
				this.RETURN_PAGE = 3;
			}
			else
			if (playback_type == RESULTSET)
			{
				player_id = get_knots().get_connection().fetch_from_address("/external/play_resultset?profile=" + profile + "&ids=" + id + lang, fetch_address, fetch_username, fetch_password).split("\n")[0];
				this.RETURN_PAGE = 0;
			}
			else
			if (playback_type == SHARE)
			{
				string[] tokens = Regex.split_simple("(.*?):\\/\\/(.*?):(.*?)@(.*?):(.*?)\\/", id);
				if (tokens.length == 7)
				{
					fetch_address = tokens[4] + ":" + tokens[5];
					fetch_username = tokens[2];
					fetch_password = tokens[3];
					player_id = get_knots().get_connection().fetch_from_address("/external/play_share?key=" + tokens[2], fetch_address, fetch_username, fetch_password, tokens[1] == "https").split("\n")[0];
					this.RETURN_PAGE = 0;
				}
				else
				{
					get_knots().alert("Unable to play the share.");
					go_back();
					return false;
				}
			}
			string? password = null;
			if (player_id != null)
			{
				password = player_id.split(":")[1];
				player_id = player_id.split(":")[0];
			}
			if (player_id != null && update_status())
			{
				handle_media_change();
				address = "http://" + player_id + ":" + password + "@" + (playback_type != SHARE ? this.get_knots().get_connection().ip() : fetch_address.split(":")[0]) + ":" + get_player_value("port") + "/" + get_player_value("stream");
				try
				{
					wid = (int)Gdk.x11_drawable_get_xid (this.embed.window);
					Thread.create(start_player, true);
				}
				catch (ThreadError e)
				{
				}
			}
			else
			{
				get_knots().alert("Stream failed to start");
				stop();
				go_back();
			}
		}
		else
		{
			get_knots().alert("Restarting playback");
			this.playing = -1;
			this.restart_ids = id;
			this.restart_type = playback_type;
			on_stop(true);
		}
		return false;
	}
	
	public bool check_update_need()
	{
		bool should_update = this.is_playing() && this.is_seekable() && this.is_showing() && get_knots().is_visible() && !this.is_restarting() && !this.fullscreen;
		if (!this.updating && should_update)
		{
			this.updating = true;
			update_status_in_thread();
			GLib.Timeout.add(1000, update_progress);
		}
		else
		if (this.updating && !should_update)
		{
			this.updating = false;
		}
		return false;
	}
	
	public override void display_state_changed(Osso.DisplayState state)
	{
		check_update_need();
	}
	
	public override void window_state_changed(bool covered)
	{
		check_update_need();
	}
	
	public bool update_progress()
	{
		TimeVal time = TimeVal();
		time.get_current_time();
		if (this.updating && !this.seeking)
		{
			int since_update = (int)(time.tv_sec - last_update.tv_sec);
			int position = (int)(parse_double(get_player_value("position")) * (double)seekbar.get_total_time()) + since_update ;
			if (position > seekbar.get_total_time())
				position = seekbar.get_total_time();
			update_timedisplay(position, false);
			set_automatic_position(position);
			if ((since_update >= 10 || (position > 0 && position == seekbar.get_total_time())) && !waiting_for_response && !busy())
			{
				update_status_in_thread();
			}
		}
		if (this.seeking)
		{
			if (time.tv_sec - last_seek.tv_sec > 0)
			{
				seek(null);
				update_status();
			}
		}
		return this.updating;
	}
	
	public bool busy()
	{
		return scroller.busy() || now_playing.busy();
	}
	
	public void update_timedisplay(int? position, bool force)
	{
		if (!seeking || force)
		{
			int total = seekbar.get_total_time();
			if (position == null)
				position = (int)(parse_double(get_player_value("position")) * (double)total);
			current_position.set_markup("<small>" + get_knots().get_info().humanize_duration(position) + " / " + get_knots().get_info().humanize_duration(total) + "</small>");
		}
	}
	
	public bool is_showing()
	{
		return this.get_knots().get_notebook().get_current_page() == 2;
	}
	
	public bool is_seekable()
	{
		return seekable == 1;
	}
	
	public bool update_seekbar()
	{
		if (!seeking)
		{
			int position = (int)(parse_double(get_player_value("position")) * (double)seekbar.get_total_time());
			set_automatic_position(position);
		}
		return false;
	}
	
	public double parse_double(string ds)
	{
		string str = ds;
		if (str == null)
			str = "0.0";
		string[] tokens = str.split(".");
		if (tokens.length == 2)
		{
			string s;
			double d = (tokens[0] + "," + tokens[1]).to_double(out s);
			if (s != null && s != "")
				d = (tokens[0] + "." + tokens[1]).to_double();
			return d;
		}
		else
			return 1;
	}
	
	public bool create_playing_list()
	{
		if (is_playing_music())
		{
			get_knots().get_connection().set_url_cache(false);
			string xml = get_knots().get_connection().fetch_from_address("/external/currently_playing_playlist?player_id=" + player_id, fetch_address, fetch_username, fetch_password);
			XMList list = new XMList(xml);
			if (list.itemcount() > 1)
			{
				var children = now_playing.get_container().get_children();
				foreach (Widget child in children)
				{
					now_playing.get_container().remove(child);
				}
				now_playing.show();
				int index = 0;
				foreach(HashTable ht in list.items())
				{
					Item item = new Item(get_knots(), ht, true);
					item.create();
					if (index == 0)
						item.highlight();
					item.button_release_event += select_item;
					((Gtk.Fixed)now_playing.get_container()).put(item, 0, 0);
					index += 1;
				}
				reorder_now_playing();
				now_playing.show_all();
			}
			else
			{
				now_playing.hide();
			}
		}
		else
		{
			now_playing.hide();
		}
		return false;
	}
	
	public void reorder_now_playing()
	{
		int x = 0;
		int y = 0;
		var children = now_playing.get_container().get_children();
		foreach (Widget child in children)
		{
			Item i = (Item)child;
			((Gtk.Fixed)now_playing.get_container()).move(i, x, y);
			if (get_knots().ORIENTATION == get_knots().LANDSCAPE)
				y += i.height();
			else
				x += i.width();
		}
		if (get_player_value("playlistindex") != null)
			highlight_item(get_player_value("playlistindex").to_int() - 1);
	}
	
	public bool select_item(Gtk.Widget w, Gdk.EventButton e)
	{
		if (!now_playing.window_scrolled())
		{
			Item i = (Item)w;
			int old_index = (get_player_value("playlistindex")).to_int();
			int new_index = get_knots().ORIENTATION == get_knots().LANDSCAPE ? (int)(i.allocation.y + e.y) / i.height() + 1 : (int)(i.allocation.x + e.x) / i.width() + 1;
			if (old_index != new_index)
			{
				i.set_clicked(true);
				get_knots().get_connection().set_url_cache(false);
				get_knots().get_connection().fetch_from_address("/external/select_playlist_item?player_id=" + player_id + "&index=" + new_index.to_string(), fetch_address, fetch_username, fetch_password);
				update_status();
				handle_media_change();
			}
		}
		return false;
	}
	
	public void highlight_item(int index)
	{
		var children = now_playing.get_container().get_children();
		int count = 0;
		foreach (Widget child in children)
		{
			Item i = (Item)child;
			if (count == index)
			{
				i.highlight();
				if (!i.was_clicked())
				{
					if (get_knots().ORIENTATION == get_knots().LANDSCAPE)
						now_playing.vadjustment.value = i.allocation.y - get_knots().get_screen_height() / 2 - i.height() / 2;
					else
						now_playing.hadjustment.value = i.allocation.x - get_knots().get_screen_width() / 2 + i.width() / 2;
				}

			}
			else
				i.lowlight();
			count += 1;
			i.set_clicked(false);
		}
	}
	
	public void* start_player()
	{
		GLib.Idle.add(create_playing_list);
		int buffer = 2;
		if (get_player_value("buffer") != null && get_player_value("buffer") != "")
		{
			buffer = get_player_value("buffer").to_int();
			if (buffer < 0)
				buffer = 0;
		}
		string player = get_knots().get_settings().get_value_default_to("player", "mplayer").down();
		knotsplayer = new KnotsPlayerBackend(get_knots(), player == "mplayer" ? 0 : 1);
		knotsplayer.play(this.address, this.wid.to_string(), buffer);
		if (!is_playing_music() && parse_double(get_player_value("position")) > 0.0)
		{
			int position = (int)(parse_double(get_player_value("position")) * (double)seekbar.get_total_time());
			if (position > seekbar.get_total_time())
				position = seekbar.get_total_time();
		}
		return null;
	}
	
	public void* stop_in_thread()
	{
		get_knots().get_connection().set_url_cache(false);
		get_knots().get_connection().fetch_from_address("/external/stop?client_id=" + player_id, fetch_address, fetch_username, fetch_password);
		return null;
	}
	
	public void stop()
	{
		stopping = false;
		unfullscreen();
		this.updating = false;
		try
		{
			Thread.create(stop_in_thread, true);
		}
		catch (GLib.ThreadError e)
		{
			stop_in_thread();
		}
		if (!this.is_restarting())
		{
			if (this.is_showing())
				go_back();
			else
				get_knots().alert("Playback stopped");
			if (RETURN_PAGE == 1)
				get_knots().get_info().update_info(null);
			this.playing = 0;
		}
		timedisplay.hide();
		get_knots().get_browser().get_toolbar_button(4).show();
		get_knots().get_browser().get_toolbar_button(5).hide();
		this.last_played = this.playing;
		window.set_title("Knots - ");
		get_knots().get_window().set_icon(get_knots().get_common().get_app_icon());
		unfullscreen();
		if (this.is_restarting())
		{
			this.playing = 0;
			play(restart_ids, restart_type);
		}
		else
		if (!this.is_playing())
		{
			revert_rotation();
		}
	}
	
	public bool is_playing_music()
	{
		return get_player_value("mediatype") != null && get_player_value("mediatype").to_int() == 1;
	}
	
	public void revert_rotation()
	{
		if (rotation_before_playback == 1 || rotation_before_playback == 3)
		{
			int current_rotation = get_knots().get_rotation();
			if (current_rotation != rotation_before_playback)
				get_knots().set_rotation(rotation_before_playback);
		}
	}
	
	public bool is_playing()
	{
		return playing != 0;
	}
	
	public bool is_restarting()
	{
		return playing == -1;
	}
	
	public void fullscreen_video()
	{
		this.fullscreen = true;
		embed.show();
		scroller.hide();
		timedisplay.hide();
		get_toolbar().hide();
		get_knots().get_window().fullscreen();
	}
	
	public void unfullscreen()
	{
		this.fullscreen = false;
		embed.hide();
		scroller.show();
		if (is_seekable())
			timedisplay.show();
		else
			timedisplay.hide();
		get_toolbar().show();
		get_knots().get_window().unfullscreen();
	}
	
	public bool toggle_controls()
	{
		fullscreen = !fullscreen;
		if (!fullscreen)
		{
			if (is_seekable())
				timedisplay.show();
			else
				timedisplay.hide();
			get_toolbar().show();
		}
		else
		{	
			timedisplay.hide();
			get_toolbar().hide();
		}
		check_update_need();
		return false;
	}
	
	public string get_player_value(string key)
	{
		if (status != null)
			return (string)status.lookup(key);
		else
		{
			if (this.is_playing())
				this.on_stop(false);
			return "";
		}
	}
	
	public bool key_event(Gdk.EventKey ev)
	{
		switch (ev.keyval)
		{
			case Gdk.KeySyms.Left:
				this.knotsplayer.player_key('9');
				break;
			case Gdk.KeySyms.Right:
				this.knotsplayer.player_key('0');
				break;
			case Gdk.KeySyms.BackSpace:
				this.on_stop(false);
				break;
			default:
				this.knotsplayer.player_key((char)ev.keyval);
			break;
		}
		return false;
	}
	
	public override string[] show_buttons()
	{
		return {"rotation"};
	}
	
	public override void reveal()
	{
		base.reveal();
		GLib.Timeout.add(500, check_update_need);
	}
	
	public override void scroll_up()
	{
		scroller.scroll_up(); 
	}
	
	public override void scroll_down()
	{
		scroller.scroll_down();
	}
}

