using GLib;
using Gtk;
using Hildon;

public class Browser : PageWidget
{
	XMList list;
	Item[] itemlist;
	int x = 0;
	int y = 0;
	public int[] browsepaths = new int[3];
	public int[] pages = new int[3];
	string? search_string;
	private SList<string> path_history;
	private SList<int> path_pages;
	private List<int> sort_list;
	private int ensure_item_visibility;
	private bool icon_view;
	private string virtual;
	private int virtual_page;
	int item_count;
	
	construct {
		sort_list = new List<int>();
		path_history = new SList<string>();
		path_pages = new SList<int>();
		ensure_item_visibility = -2;
		icon_view = false;
	}
	
	public void change_sort(Gtk.CheckMenuItem toggled)
	{
		int index = 0;
		var children = ((Gtk.Container)toggled.get_parent()).get_children();
		foreach(Gtk.Widget w in children)
		{
			Gtk.CheckMenuItem cmi = (Gtk.CheckMenuItem)w;
			if (cmi == toggled)
			{
				set_sort_field(index, cmi.active);
				return;
			}
			index += 1;
		}
	}
	
	public void select_sortable(Gtk.Menu menu, int i, bool active)
	{
		int index = 0;	
		var children = menu.get_children();
		foreach(Gtk.Widget w in children)
		{
			if (i == index)
			{
				((Gtk.CheckMenuItem)w).active = active;
				set_sort_field(index, active);
				return;
			}
			index += 1;
		}
	}
	
	public void set_icon_view(bool icon_view)
	{
		this.icon_view = icon_view;
		get_knots().get_settings().set_value("icon_view", icon_view.to_string());
	}
	
	public bool has_icon_view()
	{
		return this.icon_view;
	}
	
	public void set_sort_field(int index, bool active)
	{
		int i = (int)sort_list.find(index);
		if (i == 0 && active)
			sort_list.append(index);
		else
		if (i != 0 && !active)
			sort_list.remove(index);
	}
	
	public string sort_order()
	{
		string sort = "";
		string[] fields = {"added DESC", "modified DESC", "name", "duration DESC", "position DESC", "path", "size DESC", "views DESC", "RANDOM()"};
		foreach (int i in sort_list)
		{
			sort += (sort != "" ? "," : "") + fields[i];
		}
		if (sort == "")
			sort = "added";
		return sort;
	}
	
	public void show_disconnect_message()
	{
		string xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><root><items><item><button>Connect automatically</button><id>1</id></item><item><button>Connect manually</button><id>2</id></item></items><pages><current>1</current><total>1</total></pages></root>";
		list = new XMList(xml);
		add_items();
		get_toolbar().hide();
	}
	
	public string sort_settings()
	{
		string sort = "";
		foreach (int i in sort_list)
		{
			sort += (sort != "" ? "," : "") + i.to_string();
		}
		if (sort == "")
			sort = "0";
		return sort;
	}
	
	public override void add_signals()
	{
		get_toolbar_button(0).clicked += () => {
			go_back(true);
		};
		get_toolbar_button(1).clicked += () => {
			previous_page();
		};
		get_toolbar_button(2).clicked += () => {
			next_page();
		};
		get_toolbar_button(3).clicked += () => {
			show_search();
		};
		get_toolbar_button(4).clicked += () => {
			get_knots().get_playlist().reveal();
		};
		get_toolbar_button(5).clicked += () => {
			get_knots().get_player().return_to_player();
		};
	}
	
	public void go_to_root()
	{
		if (get_knots().get_connection().connected() && (!get_knots().get_player().is_playing() || get_knots().get_player().get_player_value("mediatype").to_int() == 1))
		{
			clear();
			if (get_knots().get_connection().server_count() == 1)
				browse();
			else
				show_serverlist();
			reveal();
		}	
	}
	
	public override Gtk.Widget create_content()
	{
		Gtk.Fixed item_container = new Gtk.Fixed();
		Scroller scroller = new Scroller(item_container);
		scroller.set_scroll_policy(false, true);
		return scroller;
	}
	
	public override string[] get_toolbar_items()
	{
		return {"back", "prev", "next", "search", "playlist", "player"};
	}
	
	public int[] get_browsepaths()
	{
		return browsepaths;
	}
	
	public int[] get_pages()
	{
		return pages;
	}
	
	public bool add_items()
	{
		var items = list.items();
		item_count = list.itemcount();
		if (items != null && items.length > 0)
		{
			itemlist = new Item[0];
			foreach(HashTable ht in items)
			{
				Item item = new Item(get_knots(), ht, this.icon_view);
				itemlist += item;
				GLib.Idle.add(update_progress);
			}
			GLib.Idle.add(show_items);
		}
		else
		{
			GLib.Idle.add(undo_browse);
		}
		ensure_item_visibility = -2;
		return false;
	}
	
	public bool undo_browse()
	{
		get_knots().alert("No results");
		go_back(false);
		get_toolbar().show();
		gtk_window_set_progress_indicator(get_knots().get_window(), 0);
		return false;
	}
	
	public bool update_progress()
	{
		if (item_count != -1)
		{
			get_knots().get_progress().init("Loading", item_count);
			item_count = -1;
		}
		get_knots().get_progress().update();
		return false;
	}
	
	public bool show_items()
	{
		clear_list();
		if (search_string != null)
		{
			get_toolbar_button(0).set_sensitive(true);
		}
		foreach(Item item in itemlist)
		{
			add_item(item, true);
		}
		if (list.pages() > list.page())
		{
			get_toolbar_button(2).set_sensitive(true);
		}
		if (list.page() > 1)
		{
			get_toolbar_button(1).set_sensitive(true);
		}
		
		((Scroller)get_content()).get_container().show_all();
		if (get_knots().get_connection().connected())
			get_toolbar().show();
		else
			get_toolbar().hide();
		gtk_window_set_progress_indicator(get_knots().get_window(), 0);
		return false;
	}
	
	public void clear_selections()
	{
		((Scroller)get_content()).enable_clicking(true);
		foreach(Item item in itemlist)
		{
			item.lowlight();
		}
	}
	
	public override void scroll_up()
	{
		((Scroller)get_content()).scroll_up(); 
	}
	
	public override void scroll_down()
	{
		((Scroller)get_content()).scroll_down();
	}
	
	public override void orientation_change()
	{
		item_count = -1;
		base.orientation_change();
		re_add_items();
	}
	
	public void add_item(Item item, bool create)
	{
		if (create)
			item.create();
		if (item.has_icon_view())
		{
			var ww = window.get_screen().get_width();
			int item_count = ww / item.width();
			int gap = (ww - item_count * item.width()) / (item_count + 1);
			x += gap;
			((Gtk.Fixed)((Scroller)get_content()).get_container()).put(item, x, y);
			x += item.width();
			if (x + item.width() > ww)
			{
				x = 0;
				y += item.height();
			}
		}
		else
		{
			((Gtk.Fixed)((Scroller)get_content()).get_container()).put(item, x, y);
			y += item.height() + 1;
		}
		if (item.get_item_id() == ensure_item_visibility)
		{
			Scroller scroller = ((Scroller)get_content());
			if (y > scroller.allocation.height - item.height())
				scroller.vadjustment.value = y - item.height();  
		}
	}
	
	public void re_add_items()
	{
		clear_list();
		foreach(Item item in itemlist)
		{
			add_item(item, false);
			if (!item.has_icon_view())
				item.new_width(window.get_screen().get_width());
		}
		get_knots().get_progress().close();
	}
	
	public void clear_list()
	{
		
		x = 0;
		y = 0;
		var children = ((Scroller)get_content()).get_container().get_children();
		foreach (Widget child in children) {
			((Scroller)get_content()).get_container().remove(child);
			child = null;
		}
		((Scroller)get_content()).enable_clicking(true);
		((Scroller)get_content()).scroll_to_top();
	}
	
	public void go_back(bool browse_back)
	{
		if (virtual != null)
		{
			virtual = null;
			virtual_page = 1;
		}
		else
		if (search_string == null)
		{
			if (path_history.length() == 0)
			{
				if (browsepaths[0] != 0)
				{
					for (int i = 0; i < 3; i++)
					{
						if (browsepaths[2 - i] != 0)
						{
							ensure_item_visibility = browsepaths[2 - i]; 
							browsepaths[2 - i] = 0;
							pages[2 - i] = 1;
							break;
						}
					}
				}
				else
				{
					show_serverlist();
					return;
				}
			}
			else
			{
				browse_by_path(null, false);
				return;
			}
		}
		else
		{
			search_string = null;
		}
		if (browse_back)
			browse();
		else
			clear_selections();
	}
	
	public void next_page()
	{
		if (path_history.length() == 0)
		{
			if (virtual == null)
			{
				for (int i = 0; i < 3; i++)
				{
					if (browsepaths[2 - i] != 0)
					{
						pages[2 - i] += 1;
						break;
					}
				}
				browse();
			}
			else
			{
				virtual_page += 1;
				show_virtual_category(null, null);
			}
		}
		else
		{
			int page = path_pages.nth_data(path_pages.length() - 1);
			page += 1;
			path_pages.remove(path_pages.nth_data(path_pages.length() - 1));
			path_pages.append(page);
			browse_by_path(null, true);
		}
	}
	
	public void previous_page()
	{
		if (path_history.length() == 0)
		{
			if (virtual == null)
			{
				for (int i = 0; i < 3; i++)
				{
					if (browsepaths[2 - i] != 0)
					{
						pages[2 - i] -= 1;
						break;
					}
				}
				browse();
			}
			else
			{
				virtual_page -= 1;
				show_virtual_category(null, null);
			}
		}
		else
		{
			int page = path_pages.nth_data(path_pages.length() - 1);
			page -= 1;
			path_pages.remove(path_pages.nth_data(path_pages.length() - 1));
			path_pages.append(page);
			browse_by_path(null, true);
		}
		
	}
	
	public void show_serverlist()
	{
		get_knots().get_connection().disconnect();
		get_knots().get_common().clear_cache(2);
		list = new XMList(get_knots().get_connection().serverlist_xml());
		add_items();
	}
	
	public void show_virtual_category(string? search, int? page)
	{
		if (search != null)
			virtual = search;
		if (page != null)
			virtual_page = page;
		get_toolbar_button(0).set_sensitive(true);
		get_toolbar_button(1).set_sensitive(false);
		get_toolbar_button(2).set_sensitive(false);
		try
		{
			gtk_window_set_progress_indicator(get_knots().get_window(), 1);
			Thread.create(browse_virtual_category, true);
		}
		catch (ThreadError e)
		{
		}
	}
	
	public void clear_current_page()
	{
		if (this.get_knots().get_notebook().get_current_page() == 0)
		{
			foreach(Item item in itemlist)
			{
				if (item.get_item_attribute("mid") != null && item.get_item_attribute("mid") != "")
				{
					get_knots().get_common().clear_image(item.get_item_attribute("mid"));
				}
			}
		}
		get_knots().get_common().clear_url(get_knots().get_connection().get_last_url());
	}
	
	public void* browse_virtual_category()
	{
		get_knots().get_connection().set_url_cache(false);
		string xml = get_knots().get_connection().fetch("/external/browse?virtual=" + virtual + "&page=" + virtual_page.to_string()); 
		list = new XMList(xml);
		add_items();
		//GLib.Idle.add(add_items);
		return null;
	}
	
	public void browse_by_path(string? path, bool page_switch)
	{
		if (!page_switch)
		{
			if (path != null)
			{
				path_history.append(path);
				path_pages.append(1);
			}
			else
			{ 
				path_history.remove(path_history.nth_data(path_history.length() - 1));
				path_pages.remove(path_pages.nth_data(path_pages.length() - 1));
			}
		}
		if (path_history.length() != 0)
		{
			get_toolbar_button(0).set_sensitive(true);
			get_toolbar_button(1).set_sensitive(false);
			get_toolbar_button(2).set_sensitive(false);
			try
			{
				gtk_window_set_progress_indicator(get_knots().get_window(), 1);
				Thread.create(browse_server_by_path, true);
			}
			catch (ThreadError e)
			{
			}
		}
		else
		{
			browse();
		}
	}
	
	public void* browse_server_by_path()
	{
		string path = path_history.nth_data(path_history.length() - 1);
		int page = path_pages.nth_data(path_pages.length() - 1);
		string xml = get_knots().get_connection().fetch("/external/browse?path=" + Soup.URI.encode(path, "") + "&page=" + page.to_string()); 
		list = new XMList(xml);
		add_items();
		//GLib.Idle.add(add_items);
		return null;
	}
	
	public bool browse()
	{
		try
		{
			get_toolbar_button(1).set_sensitive(false);
			get_toolbar_button(2).set_sensitive(false);
			gtk_window_set_progress_indicator(get_knots().get_window(), 1);
			Thread.create(browse_server, true);
		}
		catch (ThreadError e)
		{
		}
		return false;
	}
	


	public void show_search()
	{
		MessageDialog dialog = new MessageDialog.with_markup(null, 0, Gtk.MessageType.QUESTION, Gtk.ButtonsType.OK_CANCEL, "Search");
		gtk_window_set_portrait_flags(dialog, Hildon.PortraitFlags.SUPPORT);
		dialog.set_image(new Gtk.Image.from_file("/usr/share/knots/knots_button_search.png"));
		Hildon.Entry search_entry = new Hildon.Entry(SizeType.FINGER_HEIGHT);
		dialog.vbox.pack_start(search_entry, true, true, 1);
		dialog.show_all();
		var response = dialog.run();
		if (response == ResponseType.OK)
		{
			if (search_entry.get_text() != "")
			{
				get_knots().alert("Searching for " + search_entry.get_text());
				search(search_entry.get_text());
			}
		}
		dialog.destroy();
	}
	
	public void* browse_server()
	{
		string url = "/external/browse";
		if (search_string == null)
		{
			get_toolbar_button(0).set_sensitive(true);
			if (browsepaths[2] != 0)
			{
				url = "/external/browse?category=" + browsepaths[0].to_string() + "&tag=" + browsepaths[1].to_string() + "&value=" + browsepaths[2].to_string() + "&page=" + pages[2].to_string() + "&order=" + sort_order();
			}
			else
			if (browsepaths[1] != 0)
			{
				url = "/external/browse?category=" + browsepaths[0].to_string() + "&tag=" + browsepaths[1].to_string() + "&page=" + pages[1].to_string() + "&order=" + sort_order();
			}
			else
			if (browsepaths[0] != 0)
			{
				url = "/external/browse?category=" + browsepaths[0].to_string() + "&page=" + pages[0].to_string() + "&order=" + sort_order();
			}
			else
			{
				get_knots().get_connection().set_url_cache(false);
				if (get_knots().get_connection().server_count() == 1)
					get_toolbar_button(0).set_sensitive(false);
			}
		}
		else
		{
			get_knots().get_connection().set_url_cache(true);
			url = "/external/browse?search=" + search_string + "&order=" + sort_order();
		}
		string xml = get_knots().get_connection().fetch(url); 
		list = new XMList(xml);
		add_items();
		return null;
	}
	
	public void clear()
	{
		ensure_item_visibility = -2;
		clear_list();
		search_string = null;
		virtual = null;
		for (int i = 0; i < 3; i++)
		{
			browsepaths[2 - i] = 0;
			pages[2 - i] = 1;
		}
		path_history = new SList<string>();
		path_pages = new SList<int>();
	}
	
	public bool window_scrolled()
	{
		return ((Scroller)get_content()).window_scrolled();
	}
	
	public bool search(string search_box)
	{
		search_string = search_box;
		if (search_string != "")
		{
			browse();
		}
		else
			search_string = null;
		return true;
	}
	
	public override void reveal()
	{
		base.reveal();
		((Scroller)get_content()).enable_clicking(true);
	}
}
