/*
    This file is part of Kismet

    Kismet is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Kismet is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Kismet; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __GPSLIBLOCATION_H__
#define __GPSLIBLOCATION_H__

#include "config.h"

#ifdef HAVE_LIBLOCATION

#include <pthread.h>

#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>

#include "clinetframework.h"
#include "kis_netframe.h"
#include "packetchain.h"
#include "gpscore.h"

// liblocation callback functions
void liblocation_changed(LocationGPSDevice *device, gpointer userdata);
void liblocation_connected(LocationGPSDevice *new_device, gpointer userdata);
void liblocation_disconnected(LocationGPSDevice *new_device, gpointer userdata);
void liblocation_started(LocationGPSDControl *control, gpointer userdata);
void liblocation_stopped(LocationGPSDControl *control, gpointer userdata);
void liblocation_error(LocationGPSDControl *control, gpointer userdata);

// event loop
void *event_loop(void *arg);

class GPSLibLocation : public GPSCore {
public:
	GPSLibLocation();
	GPSLibLocation(GlobalRegistry *in_globalreg);
	virtual ~GPSLibLocation();

	// Hooks so we can override straight to the TCP core
	virtual int MergeSet(int in_max_fd, fd_set *out_rset, fd_set *out_wset) {
		return in_max_fd;
	}

	virtual int Poll(fd_set& in_rset, fd_set& in_wset) {
		return 0;
	}
    
	virtual int ParseData() {
		return 0;
	}

	void LocStarted();
	void LocStopped();
	void LocError();
	void LocConnected();
	void LocDisconnected();
	void LocChanged(LocationGPSDevice *device);
    
	virtual int Shutdown();

	virtual int Reconnect();
protected:
	LocationGPSDevice *device;
	LocationGPSDControl *control;

	GMainLoop *loop;
	pthread_t event_loop_thread;

	gulong sig_handler_error;
	gulong sig_handler_started;
	gulong sig_handler_stopped;
	gulong sig_handler_changed;
	gulong sig_handler_connected;
	gulong sig_handler_disconnected;
};

#endif

#endif

