/*
 * Copyright (C) 2008-2010 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
/*
 * Google Calendar Module (JSON Format parser)
 * Author: Epifanov S.A.
 * Last Modification Date: 12.03.2010
*/

#include <google.h>

#ifdef TEST
#include "../test/CTF/src/ctf.h"
#endif

/**
 * Json Format Parser
 * @param tmp Pointer on events string
 * @return Pointer on events
 * */

GPtrArray* google_json_request_parser(char* tmp)
{
    struct json_object* entry_root;
    struct json_object* event_root;
    struct json_object* buffer;
    struct tm time;
    int remind;
    char* id_string;
    char* recurrence_string;
    char* link_string;
    /*Time String Buffer for periodic event case */
    char per_start_time_string[32];
    char per_end_time_string[32];
    /*Same Buffers for other cases */
    char* start_time_string;
    char* end_time_string;
    int events_num;
    int counter;
    GPtrArray* events;
    Event* current_event;

    entry_root = NULL;
    event_root = NULL;
    buffer = NULL;
    /* Getting root of Google calendar event*/
    if ((entry_root = json_tokener_parse(tmp)) == NULL){
	return NULL;
    }
    
    if((entry_root = json_object_object_get(entry_root, JSON_FEED)) == NULL){
	return NULL;
    }
   
    if ((entry_root = json_object_object_get(entry_root, JSON_ENTRY)) == NULL){
	events_num = 0;
    } else {
    events_num = json_object_array_length(entry_root);
    g_debug("events num: %d", events_num);
    }
    /* Events array initialization */
    if ((events = g_ptr_array_new()) == NULL){
	return NULL;
    }

    for (counter = 0; counter < events_num; counter++) {
    /*TODO: check, what kimi_event_new returns.*/
	g_ptr_array_add(events, (gpointer) kimi_event_new(NULL));
    }


    /* Getting event parameters */
    for (counter = 0; counter < events_num; counter++) {

	current_event = (Event*) g_ptr_array_index(events,counter);

	if ((event_root = json_object_array_get_idx(entry_root, counter)) == NULL){
	    return NULL;
	} else {

            /*XXX: Get Event ID - it's a Bicycle with square wheels!*/
	    if ((buffer = json_object_object_get(event_root, JSON_ID)) == NULL){
		return NULL;
	    } else {
	   
		buffer = json_object_object_get(buffer, JSON_T);
		id_string = strdup(json_object_get_string(buffer));
		
		if ((current_event->id = malloc(strlen(id_string) + 1)) == NULL){
		    return NULL;
		}

		strcpy(current_event->id, id_string);
		free(id_string);
	    }
	    /* Get Ivent Edit Link */
/*
	    if ((buffer = json_object_object_get(event_root, JSON_LINK)) == NULL){
		return NULL;
	    } else {

		buffer = json_object_array_get_idx(buffer,2);
		buffer = json_object_object_get(buffer,JSON_HREF);
		link_string = strdup(json_object_get_string(buffer));

		kimi_event_set_field(current_event, "edit_link", (void*)link_string);
		kimi_event_set_field_free_function(current_event, "edit_link", *free);
	    }
*/
            /* Get Title */
	    if ((buffer = json_object_object_get(event_root, JSON_TITLE)) == NULL){
		return NULL;
	    } else {
		buffer = json_object_object_get(buffer, JSON_T);
		current_event->title = strdup(json_object_get_string(buffer));
	    }
            /* Get Content */
	    if ((buffer = json_object_object_get(event_root, JSON_CONTENT)) == NULL){
		return NULL;
	    } else {
		buffer = json_object_object_get(buffer, JSON_T);
		current_event->description = strdup(json_object_get_string(buffer));
	    }
            /* Get Start Time */
	    if ((buffer = json_object_object_get(event_root, JSON_GD_WHEN)) == NULL){
		/*Periodic event?*/
		if ((buffer = json_object_object_get(event_root, JSON_GD_RECURRENCE)) == NULL){

		    return NULL;

		} else {

		    buffer = json_object_object_get(buffer, JSON_T);
		    recurrence_string = strdup(json_object_get_string(buffer));
		    sscanf(recurrence_string, JSON_ICAL_RECURR_FORMAT,
				per_start_time_string, per_end_time_string);
		    strptime (per_start_time_string, JSON_GOOGLE_RECURR_TIME_FORMAT, &time);
		    current_event->start_time = mktime(&time);
		    strptime(per_end_time_string, JSON_GOOGLE_RECURR_TIME_FORMAT, &time);
		    current_event->end_time = mktime(&time);
		}
		
	    } else {

		buffer = json_object_array_get_idx(buffer,0);
		buffer = json_object_object_get(buffer, JSON_START_TIME);
		start_time_string = strdup(json_object_get_string(buffer));
		
		strptime (start_time_string, JSON_GOOGLE_TIME_FORMAT, &time);
		current_event->start_time = mktime(&time);
		free(start_time_string);
                /* Get End Time */
		buffer = json_object_object_get(event_root, JSON_GD_WHEN);
		buffer = json_object_array_get_idx(buffer, 0);
		buffer = json_object_object_get(buffer, JSON_END_TIME);
		end_time_string = strdup(json_object_get_string(buffer));

		strptime(end_time_string, JSON_GOOGLE_TIME_FORMAT, &time);
		current_event->end_time = mktime(&time);
		free(end_time_string);
	    }
            /* Get Event Location */
	    buffer = json_object_object_get(event_root, JSON_GD_WHERE);
	    buffer = json_object_array_get_idx(buffer, 0);
	    buffer = json_object_object_get(buffer, JSON_VALUE_STRING);
	    current_event->location = strdup(json_object_get_string(buffer));

            /* Get Reminder settings */
	    if ((buffer = json_object_object_get(event_root, JSON_GD_WHEN)) == NULL){
		buffer = json_object_object_get(event_root, JSON_GD_REMINDER);

		if (buffer != NULL){
		    buffer = json_object_array_get_idx(buffer, 0);
		    buffer = json_object_object_get(buffer, JSON_MINUTES);
		    remind = json_object_get_int(buffer) * 60;
		    current_event->remind = (time_t)remind;
		}

	    } else {

		buffer = json_object_array_get_idx(buffer, 0);
		buffer = json_object_object_get(buffer, JSON_GD_REMINDER);

		if (buffer != NULL){
		    buffer = json_object_array_get_idx(buffer, 0);
		    buffer = json_object_object_get(buffer, JSON_MINUTES);
		    remind = json_object_get_int(buffer) * 60;
		    current_event->remind = (time_t)remind;
		}
	    }
            /* Memo or Meeting check */
	    if (current_event->start_time == current_event->end_time){
		current_event->id_type = MEMO;
	    } else {
		current_event->id_type = MEETING;
	    }
	}
    }
    return events;
}
