/*
 * Copyright (C) 2008-2010 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
/*
 * Google Calendar Module (Get Event by period)
 * Author: Epifanov S.A.
 * Last Modification Date: 18.03.2010
*/

#include <google.h>

#ifdef TEST
#include "../test/CTF/src/ctf.h"
#endif

/**
 * Download events from google
 * @param data Pointer on application data structure
 * @param error Pointer on error handler
 * @return Pointer on events
 * */

GPtrArray* google_get_by_period(time_t start, time_t end, Kimi* data, GError** error)
{
    
    char* tmp = NULL;
    char start_time[TIME_ARRAY_SIZE];
    char end_time[TIME_ARRAY_SIZE];
    char url[ARRAY_MAX_SIZE];
    char auth_header[ARRAY_MAX_SIZE];
    struct curl_slist* headers = NULL;
    struct tm *tmp_time;
    google_module_data* gm_data;
    GPtrArray* events;

    printf("2\n");
    
/* Send Authorization request */
#ifndef TEST

    /*Get module data*/

    gm_data = (google_module_data*) kimi_get_module_data(MOD_ID, data, error);

#ifdef MAEMO5_ENABLED

    if(connection_wrapper(data,error)){
	g_set_error(error,REM_STRG_ERR, DOWNLOAD_ERROR_CODE, DOWNLOAD_ERROR, NULL);
	return NULL;
    }
  
#endif 
    if (gm_data->auth_token == NULL) {
	gm_data->auth_token = google_authentification(data, error);
	
	if (gm_data->auth_token == NULL){
	    g_set_error(error, REM_STRG_ERR, AUTH_ERROR_CODE, AUTH_ERROR, NULL);
	    printf("auth_error\n");
	    return NULL;
	}
    }
    /* Convert start and end times of event to google format
       TODO: right time locale*/
    
    tmp_time = localtime(&start);
    
    if (tmp_time == NULL){
	g_set_error(error, REM_STRG_ERR, DOWNLOAD_ERROR_CODE, DOWNLOAD_ERROR, NULL);
	printf("2");
	return NULL;
    }
    if (strftime(start_time, sizeof(start_time), EVENTS_URL_TIME_FMT, tmp_time) == NULL) {
	g_set_error(error, REM_STRG_ERR, DOWNLOAD_ERROR_CODE, DOWNLOAD_ERROR, NULL);
	printf("3");
	return NULL;
    }

    tmp_time = localtime(&end);

    if (tmp_time == NULL){
        g_set_error(error, REM_STRG_ERR, DOWNLOAD_ERROR_CODE, DOWNLOAD_ERROR, NULL);
	printf("4");
        return NULL;
    }
    
    if (strftime(end_time, sizeof(end_time), EVENTS_URL_TIME_FMT, tmp_time) == NULL) {
        g_set_error(error, REM_STRG_ERR, DOWNLOAD_ERROR_CODE, DOWNLOAD_ERROR, NULL);
	printf("5");
        return NULL;
    }
    

    /* Send request to server */
    sprintf(url, EVENTS_URL_BY_PER, start_time, end_time);
    strcpy(auth_header, AUTH_HEADER);
    strcat(auth_header, gm_data->auth_token);

    headers = google_curl_set_header(headers, auth_header);
    if ((tmp = google_curl_get(url, headers, 0, data)) == NULL){
     	g_set_error(error, REM_STRG_ERR, DOWNLOAD_ERROR_CODE, DOWNLOAD_ERROR, NULL);
	printf("6");
	return NULL;
    }
#else
    static int state = 0;
    
    switch (state) {
    case 0:
	tmp = strdup(GOOGLE_ANSW_STR_CORRECT);
	gm_data->resp_code = 200;
	break;
    case 1:
	tmp = strdup(GOOGLE_ANSW_STR_INCORRECT);
	gm_data->resp_code = 200;
	break;
    default:
	gm_data->resp_code = 666;
    }
    state++;
#endif /* TEST */

    /* Server Answer Analyze */

    if (gm_data->resp_code != SERV_ANSWER_OK) {
	g_set_error(error, REM_STRG_ERR, DOWNLOAD_ERROR_CODE, DOWNLOAD_ERROR, NULL);
	free(tmp);
	printf("7");
	return NULL;
    }

    if ((events = google_json_request_parser(tmp)) == NULL){
	g_set_error(error, REM_STRG_ERR, DOWNLOAD_ERROR_CODE, DOWNLOAD_ERROR, NULL);
	free(tmp);
	printf("8");
	return NULL;
    }

#ifdef TEST

    if ((!strcmp(events[0]->title,"test_title"))
	&& (!strcmp(events[0]->description,"test_content"))
	&& (!strcmp(events[0]->location,"test_where"))){
	free(tmp);
	return events;
    } else {
	free(tmp);
	printf("9");
	return NULL;

    }

#else
    free(tmp);
    return events;
#endif /* TEST */
}
