/*
 * Copyright (C) 2008-2010 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
/*
 * Google Calendar Module (Event Upload)
 * Author: Epifanov S.A.
 * Last Modification Date: 18.03.2010
*/

#include <google.h>

#ifdef TEST
#include "../test/CTF/src/ctf.h"
#endif

/**
 * Upload event to google
 * @param data Pointer on application data structure
 * @param error Pointer on error handler
 * @return Pointer on string, what contain a event ID at Google
 * */

int google_event_upload(Event* ev, Kimi* data, GError** error)
{
 
    char* tmp;
    char url[ARRAY_MAX_SIZE];
    char auth_header[ARRAY_MAX_SIZE];
    char content_header[ARRAY_MAX_SIZE];
    char send_data[ARRAY_MAX_SIZE];
    char* send_string;
    struct curl_slist* headers = NULL;
    struct tm* time;
    time_t time_buffer;
    char time_string_start[TIME_ARRAY_SIZE];
    char time_string_end[TIME_ARRAY_SIZE];
    struct json_object* entry_root;
    struct json_object* event_root;
    struct json_object* buffer;
    google_module_data* gm_data;
    char* id_string;

    /* Get Module Data */
    gm_data = (google_module_data*) kimi_get_module_data(MOD_ID, data, error);

#ifdef MAEMO5_ENABLED    

    if(connection_wrapper(data,error)){
        g_set_error(error,REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
        return 1;
    }

#endif

    /* Send Authorization request */
    gm_data->auth_token = NULL;
    if (gm_data->auth_token == NULL) {
        gm_data->auth_token = google_authentification(data, error);
        if (gm_data->auth_token == NULL){
            g_set_error(error, REM_STRG_ERR, AUTH_ERROR_CODE, AUTH_ERROR, NULL);
	    return 1;
	}
    }

    /* Set URL and headers */
    strcpy(url, EVENTS_URL);
    strcpy(auth_header, AUTH_HEADER);
    strcat(auth_header, gm_data->auth_token);

    strcpy(content_header, "Content-Type: application/atom+xml");

    headers = google_curl_set_header(headers, content_header);
    headers = google_curl_set_header(headers, auth_header);

    /* Get Event Start and End time */
    time_buffer = ev->start_time;
    if ((time = localtime(&time_buffer)) == NULL) {
	g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
	return 1;
    }
    
    if (strftime(time_string_start, sizeof(time_string_start), JSON_GOOGLE_TIME_FORMAT, time) == NULL) {
	g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
	return 1;
    }

    if (ev->id_type == MEETING) {
	time_buffer = ev->end_time;
	if ((time = localtime(&time_buffer)) == NULL) {
	    g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
	    return 1;
	}
    } else {
	time_buffer = ev->start_time;
        if ((time = localtime(&time_buffer)) == NULL) {
	    g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
	    return 1;
	}
	time->tm_min = time->tm_min + 1;
    }

    if (strftime(time_string_end, sizeof(time_string_end), JSON_GOOGLE_TIME_FORMAT, time) == NULL) {
	g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
        return 1;
    }


    /* Generate send data string */
    send_string = malloc(strlen(POST_MESSAGE_TEMPLATE)
			 + strlen(ev->title)
			 + strlen(ev->description)
			 + strlen(ev->location)
			 + strlen(time_string_start)
			 + strlen(time_string_end) + 1);

    if (send_string == NULL){
	g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
	return 1;
    }

    sprintf(send_string, POST_MESSAGE_TEMPLATE,
	    ev->title, ev->description, ev->location,
	    time_string_start, time_string_end);

    if ((tmp = google_curl_post(url, send_string, headers, 0, data)) == NULL){
	g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
	return 1;
    }

    free(send_string);

    /* Server Answer Analyze */
    if (gm_data->resp_code != SERV_ANSWER_CREATED) {
	g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
	free(tmp);
	return 1;
    }

    /* Get event Google ID from answer */
    if ((entry_root = json_tokener_parse(tmp)) == NULL){
	g_debug("11111\n");
	g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
	free(tmp);
        return 1;
    } else {

	entry_root = json_object_object_get(entry_root, JSON_ENTRY);
	    
        /*XXX: Get Event ID - it's a Bicycle with square wheels!*/
	if ((buffer = json_object_object_get(entry_root, JSON_ID)) == NULL){
	    g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
	    free(tmp);
	    return 1;
	} else {
	    buffer = json_object_object_get(buffer, JSON_T);
	    id_string = strdup(json_object_get_string(buffer));

	    if ((ev->id = malloc(strlen(id_string) + 1)) == NULL){
		g_set_error(error, REM_STRG_ERR, UPLOAD_ERROR_CODE, UPLOAD_ERROR, NULL);
		free(tmp);
		return 1;
	    }
	    
	    strcpy(ev->id, id_string);
	    free(id_string);
	}
    
    }
    free(tmp);
    return 0;
}
