/*
 * Copyright (C) 2008-2010 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
/*
 * Google Calendar Module (Authentification)
 * Author: Epifanov S.A.
 * Last Modification Date: 18.03.2010
*/

#include <google.h>

#ifdef TEST
#include "../test/CTF/src/ctf.h"
#endif
/**
 * Authentification with Google
 * @param resp_code Pointer on response code storage
 * @param Pointer on Application Data structure
 * @return Authentification token
 * */


char* google_authentification(Kimi* data, GError** error)
{

    char url[ARRAY_MAX_SIZE];
    char* tmp;
    char* login;
    char* passwd;
    Option* login_opt_ptr;
    Option* passwd_opt_ptr;
    char auth[ARRAY_MAX_SIZE];
    char sid[ARRAY_MAX_SIZE];
    char lsid[ARRAY_MAX_SIZE];
    google_module_data* gm_data;
    
    login = NULL;
    passwd = NULL;

    /* Get Module Data*/
    gm_data = (google_module_data*) kimi_get_module_data(MOD_ID, data, error);

#ifdef MAEMO5_ENABLED

    if(connection_wrapper(data,error)){
        g_set_error(error,REM_STRG_ERR, AUTH_ERROR_CODE, AUTH_ERROR, NULL);
        return NULL;
    }

#endif

    /* Get login and password from config */
    /*TODO: Appdata does't exist any more. =((*/
    //    login = g_key_file_get_string(data->KeyFile, "Service", "GoogleLogin", NULL);
    //    passwd = g_key_file_get_string(data->KeyFile, "Service", "GooglePass", NULL);
/*
  if ((login = strdup("maemo.kimi")) == NULL){
  g_set_error(error, REM_STRG_ERR, ACCOUNT_ERROR_CODE, ACCOUNT_ERROR, NULL);
  return NULL;
  }
  if ((passwd = strdup("23maemokimi1")) == NULL){
  g_set_error(error, REM_STRG_ERR, ACCOUNT_ERROR_CODE, ACCOUNT_ERROR, NULL);
  free(login);
  return NULL;
  }
*/

    login_opt_ptr = kimi_conf_get_option(gm_data->conf, "login", error);
    passwd_opt_ptr = kimi_conf_get_option(gm_data->conf, "password", error);

    if((kimi_conf_option_get_state(login_opt_ptr) == OS_UNSET)
       ||kimi_conf_option_get_state(passwd_opt_ptr) == OS_UNSET){
	kimi_conf_show_all_options_to_user(gm_data->conf,"Please enter Login and Password", error);
    }
    
    if((kimi_conf_option_get_state(login_opt_ptr) == OS_UNSET)
            ||kimi_conf_option_get_state(passwd_opt_ptr) == OS_UNSET){
        g_set_error(error, REM_STRG_ERR, AUTH_ERROR_CODE, AUTH_ERROR, NULL);
        return NULL;
    }
    
    login = kimi_conf_option_get_string(login_opt_ptr);
    passwd = kimi_conf_option_get_string(passwd_opt_ptr);

    /* Set Authorization Request */
    if (strlen(login) == 0){
	printf("0 login =(");
	g_set_error(error, REM_STRG_ERR, ACCOUNT_ERROR_CODE, ACCOUNT_ERROR, NULL);
	return NULL;
    }

    sprintf(url, AUTH_URL, login, passwd, SOURCE, SERVICE);

/* Try to authenticate */    
#ifndef TEST
    g_debug("pre_auth\n");
    if ((tmp = google_curl_get(url, NULL, 1, data)) == NULL){
	g_set_error(error, REM_STRG_ERR, AUTH_ERROR_CODE, AUTH_ERROR, NULL);
	return NULL;
    }
    g_debug("post_auth\n");
#else
    tmp = strdup("Test String Auth=test");
    static int st = 0;
    if(st == 0)
        gm_data->resp_code = 200;
    else 
        gm_data->resp_code = 666;
    
    st++;
#endif /* TEST */

    if ((gm_data->resp_code) == SERV_ANSWER_OK) {
	sscanf(tmp, "%s %s %s", &sid, &lsid, &auth);
	if ((strstr(auth, "Auth=") == NULL) && strstr(auth, "auth=") == NULL) {
	    g_set_error(error, REM_STRG_ERR, AUTH_ERROR_CODE, AUTH_ERROR, NULL);
	    return NULL;
	}
	free(tmp);
	return strdup(auth);
    } else {
	g_set_error(error, REM_STRG_ERR, AUTH_ERROR_CODE, AUTH_ERROR, NULL);
	free(tmp);
	return NULL;
    }
}
