/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#ifndef CURL_REQUEST_H
#define CURL_REQUEST_H

#include <stdio.h>
#include <string.h>
#include <curl/curl.h>
#include <kimi.h>
#include <google.h>
//#include <appdata.h>

struct MemoryStruct {
    char* memory;
    size_t size;
};

/**
 * Curl GET request
 * @param url URL for request
 * @param headers Header of request
 * @param https SSL flag(0 - Don't use SSL, 1 - Use SSL)
 * @param data Module data
 * @return Body of server answer
 * */

char* google_curl_get(const char* url, struct curl_slist* headers,
		      int https, Kimi* data);

/**
 * Curl POST module
 * @param url URL for request
 * @param send_data pointer to data, which need to be sended 
 * @param headers Headers of request
 * @param https SSL flag(0 - Don't user SSL, 1 - Use SSL)
 * @param data Module data
 * @return Body of server answer
 * */
char* google_curl_post(const char* url, char* send_data, struct curl_slist* headers,
		       int https, Kimi* data);


/**
 * Curl PUT request
 * @param url URL for request
 * @param send_data data Pointer to data, which need to be sended
 * @param headers Pointer to Header of the request
 * @param https SSL flag(0 - Don't use SSL, 1 - use SSL)
 * @param data Module data.
 * @returns Body of server answer
 * */
/*
char* google_curl_put(const char* url, char* send_data, struct curl_slist* headers,
		      int https, Kimi* data);
*/
/**
 * Curl header set module
 * @param header pointer to header
 * @return headers pointer to list of headers
 * */

struct curl_slist* google_curl_set_header(struct curl_slist* headers, const char* header);

static void* google_myrealloc(void* ptr, size_t size);
static size_t google_write_memory_callback(void* ptr, size_t size,
					      size_t nmemb, void* mydata);

#endif /* CURL_REQUEST_H */
